"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertRuleFromVisAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _triggers = require("@kbn/ui-actions-browser/src/triggers");
var _discoverUtils = require("@kbn/discover-utils");
var _presentationUtil = require("@kbn/presentation-util");
var _react = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class AlertRuleFromVisAction {
  constructor(ruleTypeRegistry, actionTypeRegistry, startDependencies) {
    (0, _defineProperty2.default)(this, "ruleTypeRegistry", void 0);
    (0, _defineProperty2.default)(this, "actionTypeRegistry", void 0);
    (0, _defineProperty2.default)(this, "startDependencies", void 0);
    (0, _defineProperty2.default)(this, "type", _triggers.ALERT_RULE_TRIGGER);
    (0, _defineProperty2.default)(this, "id", _triggers.ALERT_RULE_TRIGGER);
    (0, _defineProperty2.default)(this, "getIconType", () => 'bell');
    (0, _defineProperty2.default)(this, "getDisplayName", () => _i18n.i18n.translate('xpack.triggersActionsUI.alertRuleFromVis.actionName', {
      defaultMessage: 'Create alert rule'
    }));
    (0, _defineProperty2.default)(this, "shouldAutoExecute", async () => true);
    this.ruleTypeRegistry = ruleTypeRegistry;
    this.actionTypeRegistry = actionTypeRegistry;
    this.startDependencies = startDependencies;
  }
  async isCompatible({
    embeddable
  }) {
    const isLensApi = (0, _presentationPublishing.apiIsOfType)(embeddable, 'lens');
    if (!isLensApi || (0, _presentationPublishing.hasBlockingError)(embeddable)) return false;
    const query = embeddable.query$.getValue();
    return Boolean(query && 'esql' in query);
  }
  async execute({
    embeddable,
    data
  }) {
    var _this$startDependenci;
    const currentApp = await (0, _rxjs.firstValueFrom)((_this$startDependenci = this.startDependencies.coreStart.application.currentAppId$) !== null && _this$startDependenci !== void 0 ? _this$startDependenci : (0, _rxjs.of)(undefined));

    // Close all existing flyouts before opening the alert rule flyout
    if (currentApp === 'discover') {
      (0, _discoverUtils.dismissAllFlyoutsExceptFor)(_discoverUtils.DiscoverFlyouts.lensAlertRule);
    }
    (0, _presentationUtil.openLazyFlyout)({
      core: this.startDependencies.coreStart,
      parentApi: embeddable.parentApi,
      flyoutProps: {
        size: 620,
        css: (0, _react.css)({
          containerType: 'inline-size'
        }),
        'data-test-subj': 'lensAlertRule',
        'aria-labelledby': 'flyoutTitle'
      },
      loadContent: async ({
        closeFlyout
      }) => {
        const {
          loadAlertRuleFlyoutContent
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./load_alert_rule_flyout_content')));
        return await loadAlertRuleFlyoutContent({
          embeddable,
          data,
          closeFlyout,
          startDependencies: this.startDependencies,
          ruleTypeRegistry: this.ruleTypeRegistry,
          actionTypeRegistry: this.actionTypeRegistry
        });
      }
    });
  }
}
exports.AlertRuleFromVisAction = AlertRuleFromVisAction;