"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesListFiltersBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _get_experimental_features = require("../../../../common/get_experimental_features");
var _rules_list_statuses = require("./rules_list_statuses");
var _rules_list_auto_refresh = require("./rules_list_auto_refresh");
var _rule_execution_status_filter = require("./rule_execution_status_filter");
var _rule_last_run_outcome_filter = require("./rule_last_run_outcome_filter");
var _rules_list_error_banner = require("./rules_list_error_banner");
var _type_filter = require("./type_filter");
var _action_type_filter = require("./action_type_filter");
var _rule_tag_filter = require("./rule_tag_filter");
var _rule_status_filter = require("./rule_status_filter");
var _kql_search_bar = require("./kql_search_bar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rules_list/components/rules_list_filters_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ENTER_KEY = 13;
const RulesListFiltersBar = exports.RulesListFiltersBar = /*#__PURE__*/_react.default.memo(props => {
  const {
    actionTypes,
    filterOptions,
    filters,
    inputText,
    lastUpdate,
    onClearSelection,
    onRefreshRules,
    onToggleRuleErrors,
    rulesLastRunOutcomesTotal,
    rulesStatusesTotal,
    setInputText,
    showActionFilter = true,
    showErrors,
    canLoadRules,
    refresh,
    updateFilters
  } = props;
  const isRuleTagFilterEnabled = (0, _get_experimental_features.getIsExperimentalFeatureEnabled)('ruleTagFilter');
  const isRuleStatusFilterEnabled = (0, _get_experimental_features.getIsExperimentalFeatureEnabled)('ruleStatusFilter');
  const isRuleUsingExecutionStatus = (0, _get_experimental_features.getIsExperimentalFeatureEnabled)('ruleUseExecutionStatus');
  const getRuleTagFilter = () => {
    if (isRuleTagFilterEnabled) {
      return [/*#__PURE__*/_react.default.createElement(_rule_tag_filter.RuleTagFilter, {
        isGrouped: true,
        refresh: refresh,
        canLoadRules: canLoadRules,
        selectedTags: filters.tags || [],
        onChange: value => updateFilters({
          filter: 'tags',
          value
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 9
        }
      })];
    }
    return [];
  };
  const renderRuleStatusFilter = () => {
    if (isRuleStatusFilterEnabled) {
      return /*#__PURE__*/_react.default.createElement(_rule_status_filter.RuleStatusFilter, {
        selectedStatuses: filters.ruleStatuses || [],
        onChange: value => updateFilters({
          filter: 'ruleStatuses',
          value
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 96,
          columnNumber: 9
        }
      });
    }
    return null;
  };
  const getRuleOutcomeOrStatusFilter = () => {
    if (isRuleUsingExecutionStatus) {
      return [/*#__PURE__*/_react.default.createElement(_rule_execution_status_filter.RuleExecutionStatusFilter, {
        key: "rule-status-filter",
        selectedStatuses: filters.ruleExecutionStatuses || [],
        onChange: value => updateFilters({
          filter: 'ruleExecutionStatuses',
          value
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 9
        }
      })];
    }
    return [/*#__PURE__*/_react.default.createElement(_rule_last_run_outcome_filter.RuleLastRunOutcomeFilter, {
      key: "rule-last-run-outcome-filter",
      selectedOutcomes: filters.ruleLastRunOutcomes || [],
      onChange: value => updateFilters({
        filter: 'ruleLastRunOutcomes',
        value
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 7
      }
    })];
  };
  const toolsRight = [/*#__PURE__*/_react.default.createElement(_type_filter.TypeFilter, {
    key: "type-filter",
    options: filterOptions,
    filters: filters.types || [],
    onChange: value => updateFilters({
      filter: 'types',
      value
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  }), showActionFilter && /*#__PURE__*/_react.default.createElement(_action_type_filter.ActionTypeFilter, {
    key: "action-type-filter",
    actionTypes: actionTypes,
    filters: filters.actionTypes || [],
    onChange: value => updateFilters({
      filter: 'actionTypes',
      value
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }), ...getRuleOutcomeOrStatusFilter(), ...getRuleTagFilter()];
  const handleChange = e => {
    setInputText(e.target.value);
    if (e.target.value === '') {
      updateFilters({
        filter: 'searchText',
        value: e.target.value
      });
    }
  };
  const handleKeyup = e => {
    if (e.keyCode === ENTER_KEY) {
      updateFilters({
        filter: 'searchText',
        value: inputText
      });
    }
  };
  const isRuleKqlBarActive = (0, _get_experimental_features.getIsExperimentalFeatureEnabled)('ruleKqlBar');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_rules_list_error_banner.RulesListErrorBanner, {
    rulesLastRunOutcomes: rulesLastRunOutcomesTotal,
    setRuleExecutionStatusesFilter: value => updateFilters({
      filter: 'ruleExecutionStatuses',
      value
    }),
    setRuleLastRunOutcomesFilter: value => updateFilters({
      filter: 'ruleLastRunOutcomes',
      value
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 7
    }
  }), isRuleKqlBarActive && /*#__PURE__*/_react.default.createElement(_kql_search_bar.KqlSearchBar, {
    onQuerySubmit: kueryNode => updateFilters({
      filter: 'kueryNode',
      value: kueryNode
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "ruleSearchField",
    fullWidth: true,
    isClearable: true,
    placeholder: _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.searchPlaceholderTitle', {
      defaultMessage: 'Search'
    }),
    value: inputText,
    onChange: handleChange,
    onKeyUp: handleKeyup,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 9
    }
  }, renderRuleStatusFilter()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 11
    }
  }, toolsRight.map((tool, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 15
    }
  }, tool)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "refreshRulesButton",
    iconType: "refresh",
    onClick: () => {
      onClearSelection();
      onRefreshRules();
    },
    name: "refresh",
    color: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.refreshRulesButtonLabel",
    defaultMessage: "Refresh",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_rules_list_statuses.RulesListStatuses, {
    rulesStatuses: rulesStatusesTotal,
    rulesLastRunOutcomes: rulesLastRunOutcomesTotal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_rules_list_auto_refresh.RulesListAutoRefresh, {
    lastUpdate: lastUpdate,
    onRefresh: onRefreshRules,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 13
    }
  }))), rulesStatusesTotal.error > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "expandRulesError",
    color: "primary",
    onClick: onToggleRuleErrors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 13
    }
  }, !showErrors && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.showAllErrors",
    defaultMessage: "Show {totalStatusesError, plural, one {error} other {errors}}",
    values: {
      totalStatusesError: rulesStatusesTotal.error
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 17
    }
  }), showErrors && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.hideAllErrors",
    defaultMessage: "Hide {totalStatusesError, plural, one {error} other {errors}}",
    values: {
      totalStatusesError: rulesStatusesTotal.error
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 17
    }
  })))));
});