"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RuleTagFilter = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_get_rule_tags_query = require("@kbn/response-ops-rules-apis/hooks/use_get_rule_tags_query");
var _common = require("../../../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rules_list/components/rule_tag_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getOptionDataTestSubj = tag => `ruleTagFilterOption-${tag}`;
const loadingText = _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleTagFilter.loading', {
  defaultMessage: 'Loading tags'
});
const EMPTY_TAGS = [];
const OptionWrapper = /*#__PURE__*/(0, _react.memo)(({
  label,
  setObserver,
  canSetObserver
}) => {
  const internalSetObserver = (0, _react.useCallback)(ref => {
    if (canSetObserver && ref) {
      setObserver(ref);
    }
  }, [canSetObserver, setObserver]);
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: internalSetObserver,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 12
    }
  }, label);
});
const RuleTagFilterPopoverButton = /*#__PURE__*/(0, _react.memo)(({
  isSelected,
  selectedTags,
  onClosePopover,
  buttonDataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "data-test-subj": buttonDataTestSubj,
    iconType: "arrowDown",
    isSelected: isSelected,
    hasActiveFilters: selectedTags.length > 0,
    numActiveFilters: selectedTags.length,
    numFilters: selectedTags.length,
    onClick: onClosePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.ruleTagFilterButton",
    defaultMessage: "Tags",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }));
});
const RuleTagFilterList = /*#__PURE__*/(0, _react.memo)(({
  options,
  renderOption,
  onChange,
  onSearchTextChange,
  isLoading,
  loadingMessage,
  noMatchesMessage,
  emptyMessage,
  errorMessage,
  selectableDataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    searchable: true,
    searchProps: {
      onChange: onSearchTextChange
    },
    listProps: {
      // We need to specify undefined here as the selectable list will
      // sometimes scroll to the first item in the list when paginating
      activeOptionIndex: undefined
    },
    "data-test-subj": selectableDataTestSubj,
    options: options,
    noMatchesMessage: isLoading ? loadingMessage : noMatchesMessage,
    emptyMessage: isLoading ? loadingMessage : emptyMessage,
    errorMessage: errorMessage,
    renderOption: renderOption,
    onChange: onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  }), list));
});
const RuleTagFilter = exports.default = exports.RuleTagFilter = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    selectedTags = EMPTY_TAGS,
    isGrouped = false,
    canLoadRules = true,
    refresh,
    loadingMessage = loadingText,
    noMatchesMessage,
    emptyMessage,
    errorMessage,
    dataTestSubj = 'ruleTagFilter',
    selectableDataTestSubj = 'ruleTagFilterSelectable',
    optionDataTestSubj = getOptionDataTestSubj,
    buttonDataTestSubj = 'ruleTagFilterButton',
    onChange = () => {}
  } = props;
  const {
    services: {
      http,
      notifications: {
        toasts
      }
    }
  } = (0, _common.useKibana)();
  const observerRef = (0, _react.useRef)();
  const [searchText, setSearchText] = (0, _react.useState)('');
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    tags = EMPTY_TAGS,
    isLoading,
    hasNextPage,
    fetchNextPage
  } = (0, _use_get_rule_tags_query.useGetRuleTagsQuery)({
    http,
    toasts,
    enabled: canLoadRules,
    refresh,
    search: searchText
  });
  const fetchNext = (0, _react.useCallback)(async () => {
    if (hasNextPage && !isLoading) {
      var _observerRef$current;
      await fetchNextPage();
      (_observerRef$current = observerRef.current) === null || _observerRef$current === void 0 ? void 0 : _observerRef$current.disconnect();
    }
  }, [fetchNextPage, hasNextPage, isLoading]);
  (0, _react.useEffect)(() => {
    return () => {
      var _observerRef$current2;
      return (_observerRef$current2 = observerRef.current) === null || _observerRef$current2 === void 0 ? void 0 : _observerRef$current2.disconnect();
    };
  }, []);
  const allTags = (0, _react.useMemo)(() => {
    return [...new Set(selectedTags.sort().concat(tags))];
  }, [selectedTags, tags]);

  // Attaches an intersection observer to the last element
  // to trigger a callback to paginate when the user scrolls to it
  const setObserver = (0, _react.useCallback)(ref => {
    var _observerRef$current3, _observerRef$current4;
    (_observerRef$current3 = observerRef.current) === null || _observerRef$current3 === void 0 ? void 0 : _observerRef$current3.disconnect();
    observerRef.current = new IntersectionObserver(fetchNext, {
      root: null,
      threshold: 1
    });
    (_observerRef$current4 = observerRef.current) === null || _observerRef$current4 === void 0 ? void 0 : _observerRef$current4.observe(ref);
  }, [fetchNext]);
  const options = (0, _react.useMemo)(() => allTags.map(tag => ({
    label: tag,
    checked: selectedTags.includes(tag) ? 'on' : undefined,
    'data-test-subj': optionDataTestSubj(tag)
  })), [allTags, selectedTags, optionDataTestSubj]);
  const renderOption = (0, _react.useCallback)(option => {
    return /*#__PURE__*/_react.default.createElement(OptionWrapper, {
      label: option.label,
      setObserver: setObserver,
      canSetObserver: option.label === allTags[allTags.length - 1],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 237,
        columnNumber: 9
      }
    });
  }, [setObserver, allTags]);
  const onChangeInternal = (0, _react.useCallback)(newOptions => {
    const newSelectedTags = newOptions.reduce((result, option) => {
      if (option.checked === 'on') {
        result = [...result, option.label];
      }
      return result;
    }, []);
    onChange(newSelectedTags);
  }, [onChange]);
  const onSearchTextChange = (0, _react.useCallback)(newSearchText => {
    setSearchText(newSearchText);
  }, [setSearchText]);
  const onClosePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(prevIsPopoverOpen => !prevIsPopoverOpen);
  }, [setIsPopoverOpen]);
  const Container = (0, _react.useMemo)(() => {
    if (isGrouped) {
      return _react.default.Fragment;
    }
    return _eui.EuiFilterGroup;
  }, [isGrouped]);
  return /*#__PURE__*/_react.default.createElement(Container, (0, _extends2.default)({}, isGrouped ? {} : {
    'data-test-subj': 'ruleTagFilterUngrouped'
  }, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": dataTestSubj,
    isOpen: isPopoverOpen,
    closePopover: onClosePopover,
    button: /*#__PURE__*/_react.default.createElement(RuleTagFilterPopoverButton, {
      isSelected: isPopoverOpen,
      selectedTags: selectedTags,
      onClosePopover: onClosePopover,
      buttonDataTestSubj: buttonDataTestSubj,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(RuleTagFilterList, {
    isLoading: isLoading,
    options: options,
    renderOption: renderOption,
    onChange: onChangeInternal,
    onSearchTextChange: onSearchTextChange,
    loadingMessage: loadingMessage,
    noMatchesMessage: noMatchesMessage,
    emptyMessage: emptyMessage,
    errorMessage: errorMessage,
    selectableDataTestSubj: selectableDataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 9
    }
  })));
});

// eslint-disable-next-line import/no-default-export