"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRuleSnoozed = exports.getNextRuleSnoozeSchedule = void 0;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isRuleSnoozed = rule => Boolean(rule.isSnoozedUntil && new Date(rule.isSnoozedUntil).getTime() > Date.now() || rule.muteAll);
exports.isRuleSnoozed = isRuleSnoozed;
const getNextRuleSnoozeSchedule = rule => {
  if (!rule.snoozeSchedule) return null;
  // Disregard any snoozes without ids; these are non-scheduled snoozes
  const explicitlyScheduledSnoozes = rule.snoozeSchedule.filter(s => Boolean(s.id));
  if (explicitlyScheduledSnoozes.length === 0) return null;
  const nextSchedule = explicitlyScheduledSnoozes.reduce((a, b) => {
    if ((0, _moment.default)(b.rRule.dtstart).isBefore((0, _moment.default)(a.rRule.dtstart))) return b;
    return a;
  });
  return nextSchedule;
};
exports.getNextRuleSnoozeSchedule = getNextRuleSnoozeSchedule;