"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageLicenseModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rules_list/components/manage_license_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ManageLicenseModal = ({
  licenseType,
  ruleTypeId,
  onConfirm,
  onCancel
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const licenseRequired = (0, _lodash.capitalize)(licenseType);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.manageLicense.manageLicenseTitle', {
      defaultMessage: '{licenseRequired} license required',
      values: {
        licenseRequired
      }
    }),
    onCancel: onCancel,
    onConfirm: onConfirm,
    confirmButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.manageLicense.manageLicenseConfirmButtonText', {
      defaultMessage: 'Manage license'
    }),
    cancelButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.manageLicense.manageLicenseCancelButtonText', {
      defaultMessage: 'Cancel'
    }),
    defaultFocusedButton: "confirm",
    "data-test-subj": "manageLicenseModal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.manageLicense.manageLicenseMessage",
    defaultMessage: "Rule type {ruleTypeId} is disabled because it requires a {licenseRequired} license. Continue to License Management to view upgrade options.",
    values: {
      ruleTypeId,
      licenseRequired
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  })));
};
exports.ManageLicenseModal = ManageLicenseModal;