"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KqlSearchBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _esQuery = require("@kbn/es-query");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _lodash = require("lodash");
var _kibana = require("../../../../../common/lib/kibana");
var _constants = require("../../../alerts_search_bar/constants");
var _validate_kuery_node = require("./validate_kuery_node");
var _constants2 = require("./constants");
var _helpers = require("./helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rules_list/components/kql_search_bar/kql_search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const KqlSearchBar = exports.KqlSearchBar = /*#__PURE__*/_react.default.memo(({
  onQuerySubmit
}) => {
  const {
    http,
    notifications: {
      toasts
    },
    unifiedSearch: {
      ui: {
        SearchBar
      }
    }
  } = (0, _kibana.useKibana)().services;
  const {
    value: fields,
    loading,
    error
  } = (0, _useAsync.default)(async () => {
    return http.post(`/internal/rules/saved_objects/fields`, {
      body: JSON.stringify({
        fields: Object.keys(_constants2.suggestionsAbstraction.fields).filter(key => key.includes('alert.'))
      })
    });
  }, []);
  const dataView = [{
    title: '',
    fieldFormatMap: {},
    fields: fields === null || fields === void 0 ? void 0 : fields.map(field => {
      return {
        ...field,
        ...(_constants2.suggestionsAbstraction.fields[field.name] ? {
          customLabel: _constants2.suggestionsAbstraction.fields[field.name].displayField
        } : {}),
        ...(field.esTypes.includes('flattened') ? {
          type: 'string'
        } : {})
      };
    })
  }];
  const saMemo = (0, _react.useMemo)(() => (0, _helpers.enhanceSuggestionAbstractionFields)(_constants2.suggestionsAbstraction), []);
  const handleQuerySubmit = ({
    query
  }) => {
    let kueryNode = {};
    if (!(0, _lodash.isEmpty)(query === null || query === void 0 ? void 0 : query.query)) {
      var _query$query;
      kueryNode = (0, _esQuery.fromKueryExpression)((_query$query = query === null || query === void 0 ? void 0 : query.query) !== null && _query$query !== void 0 ? _query$query : '');
      try {
        (0, _validate_kuery_node.validateFieldsKueryNode)({
          astFilter: kueryNode,
          suggestionsAbstraction: saMemo
        });
      } catch (e) {
        toasts.addDanger(e.toString());
        return;
      }
    }
    onQuerySubmit(kueryNode);
  };
  return /*#__PURE__*/_react.default.createElement(SearchBar, {
    appName: "StackRules",
    disableQueryLanguageSwitcher: true,
    query: {
      query: '',
      language: 'kuery'
    },
    indexPatterns: loading || error ? _constants.NO_INDEX_PATTERNS : dataView,
    showAutoRefreshOnly: false,
    showDatePicker: false,
    showQueryInput: true,
    showQueryMenu: false,
    showFilterBar: true,
    showSubmitButton: false,
    suggestionsAbstraction: saMemo,
    onQuerySubmit: handleQuerySubmit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  });
});