"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RuleDefinition = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/alerting-plugin/common");
var _hooks = require("@kbn/alerts-ui-shared/src/common/hooks");
var _kibana = require("../../../../common/lib/kibana");
var _capabilities = require("../../../lib/capabilities");
var _rule_actions = require("./rule_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/rule_details/components/rule_definition.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INITIAL_FILTERED_RULE_TYPES = [];
const RuleDefinition = exports.default = exports.RuleDefinition = /*#__PURE__*/(0, _react.memo)(({
  rule,
  actionTypeRegistry,
  ruleTypeRegistry,
  hideEditButton = false,
  filteredRuleTypes = INITIAL_FILTERED_RULE_TYPES,
  navigateToEditRuleForm
}) => {
  var _rule$params$criteria, _ruleTypeIndex$get;
  const {
    application: {
      capabilities,
      navigateToApp
    },
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const [ruleType, setRuleType] = (0, _react.useState)();
  const hasConditions = !!(rule !== null && rule !== void 0 && (_rule$params$criteria = rule.params.criteria) !== null && _rule$params$criteria !== void 0 && _rule$params$criteria.length);
  const {
    ruleTypesState: {
      data: ruleTypeIndex,
      isLoading: ruleTypesIsLoading
    }
  } = (0, _hooks.useGetRuleTypesPermissions)({
    http,
    toasts,
    filteredRuleTypes
  });
  const ruleTypes = (0, _react.useMemo)(() => [...ruleTypeIndex.values()], [ruleTypeIndex]);
  const getRuleType = (0, _react.useMemo)(() => {
    if (ruleTypes.length && rule) {
      return ruleTypes.find(type => type.id === rule.ruleTypeId);
    }
  }, [rule, ruleTypes]);
  (0, _react.useEffect)(() => {
    setRuleType(getRuleType);
  }, [getRuleType]);
  const getRuleConditionsWording = () => {
    const numberOfConditions = rule !== null && rule !== void 0 && rule.params.criteria ? (rule === null || rule === void 0 ? void 0 : rule.params.criteria).length : 0;
    return _i18n.i18n.translate('xpack.triggersActionsUI.ruleDetails.conditions', {
      defaultMessage: '{numberOfConditions, plural, one {# condition} other {# conditions}}',
      values: {
        numberOfConditions
      }
    });
  };
  const canReadActions = (0, _capabilities.hasShowActionsCapability)(capabilities);
  const canExecuteActions = (0, _capabilities.hasExecuteActionsCapability)(capabilities);
  const canSaveRule = rule && (0, _capabilities.hasAllPrivilege)(rule.consumer, ruleType) && (
  // if the rule has actions, can the user save the rule's action params
  canExecuteActions || !canExecuteActions && rule.actions.length === 0);
  const hasEditButton = (0, _react.useMemo)(() => {
    if (hideEditButton) {
      return false;
    }
    // can the user save the rule
    return canSaveRule && (
    // is this rule type editable from within Rules Management
    ruleTypeRegistry.has(rule.ruleTypeId) ? !ruleTypeRegistry.get(rule.ruleTypeId).requiresAppContext : false);
  }, [hideEditButton, canSaveRule, ruleTypeRegistry, rule]);
  const ruleDescription = (0, _react.useMemo)(() => {
    if (ruleTypeRegistry.has(rule.ruleTypeId)) {
      return ruleTypeRegistry.get(rule.ruleTypeId).description;
    }
    if (rule.ruleTypeId === _elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_ALERT_TYPE_ID) {
      return _i18n.i18n.translate('xpack.triggersActionsUI.ruleDetails.attackDiscoveryRule', {
        defaultMessage: 'Attack Discovery rule'
      });
    }
    // TODO: Replace this generic description with proper SIEM rule descriptions
    if (rule.consumer === _ruleDataUtils.AlertConsumers.SIEM) {
      return _i18n.i18n.translate('xpack.triggersActionsUI.ruleDetails.securityDetectionRule', {
        defaultMessage: 'Security detection rule'
      });
    }
    return '';
  }, [rule, ruleTypeRegistry]);
  const onEditRuleClick = () => {
    if (navigateToEditRuleForm) {
      navigateToEditRuleForm(rule.id);
      return;
    }
    navigateToApp('management', {
      path: `insightsAndAlerting/triggersActions/${(0, _ruleDataUtils.getEditRuleRoute)(rule.id)}`,
      state: {
        returnApp: 'management',
        returnPath: `insightsAndAlerting/triggersActions/${(0, _ruleDataUtils.getRuleDetailsRoute)(rule.id)}`
      }
    });
  };
  const ruleDefinitionList = [{
    title: _i18n.i18n.translate('xpack.triggersActionsUI.ruleDetails.ruleType', {
      defaultMessage: 'Rule type'
    }),
    description: ruleTypesIsLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": "ruleSummaryRuleTypeLoadingSpinner",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 13
      }
    })) : /*#__PURE__*/_react.default.createElement(ItemValueRuleSummary, {
      "data-test-subj": "ruleSummaryRuleType",
      itemValue: ((_ruleTypeIndex$get = ruleTypeIndex.get(rule.ruleTypeId)) === null || _ruleTypeIndex$get === void 0 ? void 0 : _ruleTypeIndex$get.name) || rule.ruleTypeId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 11
      }
    })
  }, {
    title: _i18n.i18n.translate('xpack.triggersActionsUI.ruleDetails.description', {
      defaultMessage: 'Description'
    }),
    description: /*#__PURE__*/_react.default.createElement(ItemValueRuleSummary, {
      "data-test-subj": "ruleSummaryRuleDescription",
      itemValue: ruleDescription,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 11
      }
    })
  }, {
    title: _i18n.i18n.translate('xpack.triggersActionsUI.ruleDetails.runsEvery', {
      defaultMessage: 'Runs every'
    }),
    description: /*#__PURE__*/_react.default.createElement(ItemValueRuleSummary, {
      "data-test-subj": "ruleSummaryRuleInterval",
      itemValue: (0, _common.formatDuration)(rule.schedule.interval),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 11
      }
    })
  }, ...(hasConditions ? [{
    title: _i18n.i18n.translate('xpack.triggersActionsUI.ruleDetails.conditionsTitle', {
      defaultMessage: 'Conditions'
    }),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      "data-test-subj": "ruleSummaryRuleConditions",
      alignItems: "center",
      gutterSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 19
      }
    }, hasEditButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: onEditRuleClick,
      flush: "left",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 25
      }
    }, getRuleConditionsWording())) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 23
      }
    }, getRuleConditionsWording())))
  }] : []), {
    title: _i18n.i18n.translate('xpack.triggersActionsUI.ruleDetails.actions', {
      defaultMessage: 'Actions'
    }),
    description: canReadActions ? /*#__PURE__*/_react.default.createElement(_rule_actions.RuleActions, {
      ruleActions: rule.actions,
      actionTypeRegistry: actionTypeRegistry,
      legacyNotifyWhen: rule.notifyWhen,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.triggersActionsUI.ruleDetails.cannotReadActions', {
      defaultMessage: 'Connector feature privileges are required to view actions'
    })))
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "ruleSummaryRuleDefinition",
    grow: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasBorder: false,
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.ruleDetails.definition', {
    defaultMessage: 'Definition'
  }))), ruleTypesIsLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "ruleDetailsEditButtonLoadingSpinner",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 17
    }
  })) : hasEditButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "ruleDetailsEditButton",
    iconType: 'pencil',
    onClick: onEditRuleClick,
    "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.ruleDetails.editButton', {
      defaultMessage: 'Edit Rule'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    type: "column",
    listItems: ruleDefinitionList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 11
    }
  })));
});
function ItemValueRuleSummary({
  itemValue,
  extraSpace = true,
  ...otherProps
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, (0, _extends2.default)({
    grow: extraSpace ? 3 : 1
  }, otherProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 7
    }
  }, itemValue));
}

// eslint-disable-next-line import/no-default-export