"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withActionOperations = withActionOperations;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _action_connector_api = require("../../../lib/action_connector_api");
var _load_execution_kpi_aggregations = require("../../../lib/action_connector_api/load_execution_kpi_aggregations");
var _load_execution_log_aggregations = require("../../../lib/action_connector_api/load_execution_log_aggregations");
var _kibana = require("../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/common/components/with_actions_api_operations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function withActionOperations(WrappedComponent) {
  return props => {
    const {
      http
    } = (0, _kibana.useKibana)().services;
    return /*#__PURE__*/_react.default.createElement(WrappedComponent, (0, _extends2.default)({}, props, {
      loadActionTypes: async () => (0, _action_connector_api.loadActionTypes)({
        http,
        includeSystemActions: true
      }),
      loadGlobalConnectorExecutionLogAggregations: async loadProps => (0, _load_execution_log_aggregations.loadGlobalConnectorExecutionLogAggregations)({
        ...loadProps,
        http
      }),
      loadGlobalConnectorExecutionKPIAggregations: async loadGlobalExecutionKPIAggregationsProps => (0, _load_execution_kpi_aggregations.loadGlobalConnectorExecutionKPIAggregations)({
        ...loadGlobalExecutionKPIAggregationsProps,
        http
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 7
      }
    }));
  };
}