"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventLogListCellRenderer = exports.DEFAULT_DATE_FORMAT = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _format_rule_alert_count = require("../../../../../common/lib/format_rule_alert_count");
var _kibana = require("../../../../../common/lib/kibana");
var _event_log_list_status = require("./event_log_list_status");
var _rule_duration_format = require("../../../rules_list/components/rule_duration_format");
var _constants = require("../../../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/common/components/event_log/event_log_list_cell_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_DATE_FORMAT = exports.DEFAULT_DATE_FORMAT = 'MMM D, YYYY @ HH:mm:ss.SSS';
const EventLogListCellRenderer = props => {
  const {
    columnId,
    value,
    version,
    dateFormat = DEFAULT_DATE_FORMAT,
    ruleId,
    spaceIds,
    useExecutionStatus = true,
    getRuleDetailsRoute
  } = props;
  const spacesData = (0, _kibana.useSpacesData)();
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const history = (0, _reactRouterDom.useHistory)();
  const activeSpace = (0, _react.useMemo)(() => spacesData === null || spacesData === void 0 ? void 0 : spacesData.spacesMap.get(spacesData === null || spacesData === void 0 ? void 0 : spacesData.activeSpaceId), [spacesData]);
  const ruleOnDifferentSpace = (0, _react.useMemo)(() => activeSpace && !(spaceIds !== null && spaceIds !== void 0 && spaceIds.includes(activeSpace.id)), [activeSpace, spaceIds]);
  const ruleNamePathname = (0, _react.useMemo)(() => {
    if (!ruleId) return '';
    const ruleRoute = getRuleDetailsRoute ? getRuleDetailsRoute(ruleId) : (0, _ruleDataUtils.getRuleDetailsRoute)(ruleId);
    if (ruleOnDifferentSpace) {
      const [linkedSpaceId] = spaceIds !== null && spaceIds !== void 0 ? spaceIds : [];
      const basePath = http.basePath.get();
      const spacePath = linkedSpaceId !== 'default' ? `/s/${linkedSpaceId}` : '';
      const historyPathname = history.location.pathname;
      const newPathname = `${basePath.replace(`/s/${activeSpace.id}`, '')}${spacePath}${window.location.pathname.replace(basePath, '').replace(historyPathname, ruleRoute)}`;
      return newPathname;
    }
    return ruleRoute;
  }, [ruleId, ruleOnDifferentSpace, history, activeSpace, http, spaceIds, getRuleDetailsRoute]);
  const onClickRuleName = (0, _react.useCallback)(() => {
    if (!ruleId) return;
    if (ruleOnDifferentSpace) {
      const newUrl = window.location.href.replace(window.location.pathname, ruleNamePathname);
      window.open(newUrl, '_blank');
      return;
    }
    history.push(ruleNamePathname);
  }, [ruleNamePathname, history, ruleOnDifferentSpace, ruleId]);
  if (typeof value === 'undefined') {
    return null;
  }
  if (columnId === 'status') {
    return /*#__PURE__*/_react.default.createElement(_event_log_list_status.EventLogListStatus, {
      status: value,
      useExecutionStatus: useExecutionStatus,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 7
      }
    });
  }
  if (columnId === 'timestamp') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _moment.default)(value).format(dateFormat));
  }
  if (columnId === 'rule_name' && ruleId) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: onClickRuleName,
      "data-href": ruleNamePathname,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 7
      }
    }, value);
  }
  if (columnId === 'space_ids') {
    var _spacesData$spacesMap, _spacesData$spacesMap2;
    if (activeSpace && value.includes(activeSpace.id)) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, activeSpace.name);
    if (spacesData) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (_spacesData$spacesMap = (_spacesData$spacesMap2 = spacesData.spacesMap.get(value[0])) === null || _spacesData$spacesMap2 === void 0 ? void 0 : _spacesData$spacesMap2.name) !== null && _spacesData$spacesMap !== void 0 ? _spacesData$spacesMap : value[0]);
  }
  if (_constants.RULE_EXECUTION_LOG_ALERT_COUNT_COLUMNS.includes(columnId)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _format_rule_alert_count.formatRuleAlertCount)(value, version));
  }
  if (_constants.RULE_EXECUTION_LOG_DURATION_COLUMNS.includes(columnId)) {
    return /*#__PURE__*/_react.default.createElement(_rule_duration_format.RuleDurationFormat, {
      duration: parseInt(value, 10),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 12
      }
    });
  }
  if (columnId === 'timed_out') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value ? 'true' : 'false');
  }
  if (columnId === 'maintenance_window_ids') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Array.isArray(value) ? value.join(', ') : '');
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value);
};
exports.EventLogListCellRenderer = EventLogListCellRenderer;