"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StackAlertsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _reactQuery = require("@tanstack/react-query");
var _i18nReact = require("@kbn/i18n-react");
var _responseOpsAlertsTable = require("@kbn/response-ops-alerts-table");
var _constants = require("@kbn/response-ops-alerts-table/constants");
var _query_client = require("@kbn/response-ops-alerts-table/query_client");
var _configuration = require("@kbn/response-ops-alerts-table/configuration");
var _alertsUiShared = require("@kbn/alerts-ui-shared");
var _alert_actions_cell = require("@kbn/response-ops-alerts-table/components/alert_actions_cell");
var _constants2 = require("../../../../common/constants");
var _no_permission_prompt = require("../../../components/prompts/no_permission_prompt");
var _use_rule_stats = require("../hooks/use_rule_stats");
var _breadcrumb = require("../../../lib/breadcrumb");
var _url_synced_alerts_search_bar = require("../../alerts_search_bar/url_synced_alerts_search_bar");
var _kibana = require("../../../../common/lib/kibana");
var _use_alert_search_bar_state_container = require("../../alerts_search_bar/use_alert_search_bar_state_container");
var _doc_title = require("../../../lib/doc_title");
var _search_filters = require("../../../lib/search_filters");
var _utils = require("../../../../../common/utils");
var _use_rule_type_ids_by_feature_id = require("../hooks/use_rule_type_ids_by_feature_id");
var _translations = require("../../translations");
var _constants3 = require("../../alerts_search_bar/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/alerts_page/components/stack_alerts_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * A unified view for all types of alerts
 */
const StackAlertsPage = () => {
  return /*#__PURE__*/_react.default.createElement(_use_alert_search_bar_state_container.Provider, {
    value: _use_alert_search_bar_state_container.alertSearchBarStateContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: _query_client.alertsTableQueryClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(PageContentWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  })));
};
exports.StackAlertsPage = StackAlertsPage;
const getFeatureFilterLabel = featureName => _i18n.i18n.translate('xpack.triggersActionsUI.sections.stackAlertsPage.featureRuleTypes', {
  defaultMessage: '{feature} rule types',
  values: {
    feature: featureName
  }
});
const PageContentWrapperComponent = () => {
  const {
    chrome: {
      docTitle
    },
    setBreadcrumbs,
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const {
    ruleTypesState: {
      data: ruleTypesIndex,
      isInitialLoad: isInitialLoadingRuleTypes
    },
    authorizedToReadAnyRules
  } = (0, _alertsUiShared.useGetRuleTypesPermissions)({
    http,
    toasts,
    filteredRuleTypes: []
  });
  const ruleTypeIdsByFeatureId = (0, _use_rule_type_ids_by_feature_id.useRuleTypeIdsByFeatureId)(ruleTypesIndex);
  (0, _react.useEffect)(() => {
    setBreadcrumbs([(0, _breadcrumb.getAlertingSectionBreadcrumb)('alerts')]);
    docTitle.change((0, _doc_title.getCurrentDocTitle)('alerts'));
  }, [docTitle, setBreadcrumbs]);
  return !isInitialLoadingRuleTypes ? /*#__PURE__*/_react.default.createElement(PageContent, {
    isLoading: isInitialLoadingRuleTypes,
    authorizedToReadAnyRules: authorizedToReadAnyRules,
    ruleTypeIdsByFeatureId: ruleTypeIdsByFeatureId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }) : null;
};
const PageContentWrapper = /*#__PURE__*/_react.default.memo(PageContentWrapperComponent);
const PageContentComponent = ({
  isLoading,
  authorizedToReadAnyRules,
  ruleTypeIdsByFeatureId
}) => {
  const {
    data,
    http,
    notifications,
    fieldFormats,
    application,
    licensing,
    settings
  } = (0, _kibana.useKibana)().services;
  const ruleTypeIdsByFeatureIdEntries = Object.entries(ruleTypeIdsByFeatureId);
  const [esQuery, setEsQuery] = (0, _react.useState)({
    bool: {}
  });
  const [ruleTypeIds, setRuleTypeIds] = (0, _react.useState)(() => getInitialRuleTypeIds(ruleTypeIdsByFeatureId));
  const [consumers, setConsumers] = (0, _react.useState)(_constants3.NON_SIEM_CONSUMERS);
  const [selectedFilters, setSelectedFilters] = (0, _react.useState)([]);
  const ruleStats = (0, _use_rule_stats.useRuleStats)({
    ruleTypeIds
  });
  const isFilteringSecurityRules = ruleTypeIds.every(_ruleDataUtils.isSiemRuleType);
  const onFilterSelected = (0, _react.useCallback)(filters => {
    const newRuleTypeIds = [...new Set(filters.flatMap(ruleTypeId => ruleTypeId.meta.ruleTypeIds).filter(_utils.nonNullable))];
    const newConsumers = [...new Set(filters.flatMap(ruleTypeId => ruleTypeId.meta.consumers).filter(_utils.nonNullable))];
    setSelectedFilters(filters);
    if (newRuleTypeIds.length > 0) {
      setRuleTypeIds(newRuleTypeIds);
      setConsumers(newConsumers);
      return;
    }
    setRuleTypeIds(getInitialRuleTypeIds(ruleTypeIdsByFeatureId));
    setConsumers(_constants3.NON_SIEM_CONSUMERS);
  }, [ruleTypeIdsByFeatureId]);
  const quickFilters = (0, _react.useMemo)(() => {
    const filters = [];
    if (ruleTypeIdsByFeatureIdEntries.length > 0) {
      filters.push(...ruleTypeIdsByFeatureIdEntries.map(([consumer, _ruleTypeIds]) => {
        var _producerData$subFeat;
        const producerData = _constants.alertProducersData[consumer];
        if (!producerData) {
          return null;
        }
        const filterLabel = getFeatureFilterLabel(producerData.displayName);
        const shouldDisable = isFilteringSecurityRules && consumer !== _ruleDataUtils.AlertConsumers.SIEM || !isFilteringSecurityRules && consumer === _ruleDataUtils.AlertConsumers.SIEM;
        const isQuickFilterSelected = _ruleTypeIds.every(ruleTypeId => ruleTypeIds.includes(ruleTypeId));
        const disabled = selectedFilters.length > 0 && (shouldDisable || isQuickFilterSelected);
        return {
          name: filterLabel,
          icon: producerData.icon,
          filter: (0, _search_filters.createRuleTypesFilter)(_ruleTypeIds, (_producerData$subFeat = producerData.subFeatureIds) !== null && _producerData$subFeat !== void 0 ? _producerData$subFeat : [consumer], filterLabel),
          disabled
        };
      }).filter(_utils.nonNullable));
    }
    filters.push({
      title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.globalAlerts.quickFilters.status', {
        defaultMessage: 'Status'
      }),
      icon: 'bell',
      items: [_ruleDataUtils.ALERT_STATUS_ACTIVE, _ruleDataUtils.ALERT_STATUS_RECOVERED, _ruleDataUtils.ALERT_STATUS_UNTRACKED].map(s => ({
        name: s,
        filter: (0, _search_filters.createMatchPhraseFilter)(_ruleDataUtils.ALERT_STATUS, s)
      }))
    });
    return filters;
  }, [isFilteringSecurityRules, ruleTypeIds, ruleTypeIdsByFeatureIdEntries, selectedFilters.length]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Header, {
    paddingSize: "none",
    pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "appTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.managementSection.alerts.displayName",
      defaultMessage: "Alerts",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: _translations.TECH_PREVIEW_LABEL,
      tooltipContent: _translations.TECH_PREVIEW_DESCRIPTION,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 15
      }
    }))),
    bottomBorder: true,
    rightSideItems: ruleStats,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 7
    }
  }), !isLoading && !authorizedToReadAnyRules ? /*#__PURE__*/_react.default.createElement(_no_permission_prompt.NoPermissionPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    "data-test-subj": "stackAlertsPageContent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_url_synced_alerts_search_bar.UrlSyncedAlertsSearchBar, {
    appName: _constants2.ALERTS_PAGE_ID,
    ruleTypeIds: ruleTypeIds,
    showFilterControls: true,
    showFilterBar: true,
    quickFilters: quickFilters,
    onEsQueryChange: setEsQuery,
    onFilterSelected: onFilterSelected,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_responseOpsAlertsTable.AlertsTable
  // Here we force a rerender when switching feature ids to prevent the data grid
  // columns alignment from breaking after a change in the number of columns
  , {
    key: ruleTypeIds.join(),
    id: "stack-alerts-page-table",
    ruleTypeIds: ruleTypeIds,
    consumers: consumers,
    query: esQuery,
    sort: _configuration.defaultAlertsTableSort,
    showAlertStatusWithFlapping: true,
    pageSize: 20,
    showInspectButton: true,
    renderActionsCell: _alert_actions_cell.AlertActionsCell,
    services: {
      data,
      http,
      notifications,
      fieldFormats,
      application,
      licensing,
      settings
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 11
    }
  })));
};
const PageContent = /*#__PURE__*/_react.default.memo(PageContentComponent);
const getInitialRuleTypeIds = ruleTypeIdsByFeatureId => Object.entries(ruleTypeIdsByFeatureId).filter(([featureId]) => featureId !== _ruleDataUtils.AlertConsumers.SIEM).map(([_, _ruleTypeIds]) => _ruleTypeIds).flat();