"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AlertSummaryWidget = void 0;
var _react = _interopRequireWildcard(require("react"));
var _visualizationUtils = require("@kbn/visualization-utils");
var _use_load_alert_summary = require("../../hooks/use_load_alert_summary");
var _components = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/alert_summary_widget/alert_summary_widget.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertSummaryWidget = ({
  chartProps,
  ruleTypeIds,
  consumers,
  filter,
  fullSize,
  onClick = () => {},
  timeRange,
  hideChart,
  hideStats,
  onLoaded,
  dependencies: {
    charts,
    uiSettings
  }
}) => {
  const {
    alertSummary: {
      activeAlertCount,
      activeAlerts,
      recoveredAlertCount
    },
    isLoading,
    error
  } = (0, _use_load_alert_summary.useLoadAlertSummary)({
    ruleTypeIds,
    consumers,
    filter,
    timeRange
  });
  (0, _react.useEffect)(() => {
    if (!isLoading && onLoaded) {
      onLoaded({
        activeAlertCount,
        recoveredAlertCount
      });
    }
  }, [activeAlertCount, isLoading, onLoaded, recoveredAlertCount]);
  const dependencyProps = {
    baseTheme: charts.theme.useChartsBaseTheme(),
    sparklineTheme: charts.theme.useSparklineOverrides()
  };
  if (isLoading) return /*#__PURE__*/_react.default.createElement(_components.AlertSummaryWidgetLoader, {
    fullSize: fullSize,
    isLoadingWithoutChart: hideChart,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 12
    }
  });
  if (error) return /*#__PURE__*/_react.default.createElement(_components.AlertSummaryWidgetError, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 21
    }
  });
  return fullSize ?
  // Only show full size version if there is data
  activeAlertCount || recoveredAlertCount ? /*#__PURE__*/_react.default.createElement(_components.AlertSummaryWidgetFullSize, {
    activeAlertCount: activeAlertCount,
    activeAlerts: activeAlerts,
    chartProps: chartProps,
    dateFormat: timeRange.dateFormat,
    recoveredAlertCount: recoveredAlertCount,
    timeZone: (0, _visualizationUtils.getTimeZone)(uiSettings),
    hideChart: hideChart,
    hideStats: hideStats,
    dependencyProps: dependencyProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }) : null : /*#__PURE__*/_react.default.createElement(_components.AlertSummaryWidgetCompact, {
    activeAlertCount: activeAlertCount,
    activeAlerts: activeAlerts,
    chartProps: chartProps,
    onClick: onClick,
    recoveredAlertCount: recoveredAlertCount,
    timeRangeTitle: timeRange.title,
    dependencyProps: dependencyProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  });
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.AlertSummaryWidget = AlertSummaryWidget;