"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _translations = require("../../translations");
var _types = require("../../../../types");
var _kibana = require("../../../../common/lib/kibana");
var _capabilities = require("../../../lib/capabilities");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/sections/action_connector_form/edit_connector_flyout/header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FlyoutHeaderComponent = ({
  icon,
  isExperimental = false,
  subFeature,
  isPreconfigured,
  connectorName,
  connectorTypeDesc,
  selectedTab,
  setTab
}) => {
  const {
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const canExecute = (0, _capabilities.hasExecuteActionsCapability)(capabilities, subFeature);
  const setConfigurationTab = (0, _react.useCallback)(() => {
    setTab(_types.EditConnectorTabs.Configuration);
  }, [setTab]);
  const setTestTab = (0, _react.useCallback)(() => {
    setTab(_types.EditConnectorTabs.Test);
  }, [setTab]);
  const setRulesTab = (0, _react.useCallback)(() => {
    setTab(_types.EditConnectorTabs.Rules);
  }, [setTab]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    "data-test-subj": "edit-connector-flyout-header",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, icon ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: icon,
    size: "m",
    "data-test-subj": "edit-connector-flyout-header-icon",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, isPreconfigured ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "center",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: "flyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "{connectorName}",
    id: "xpack.triggersActionsUI.sections.preconfiguredConnectorForm.flyoutTitle",
    values: {
      connectorName
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 23
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: "Preconfigured",
    "data-test-subj": "preconfiguredBadge",
    tooltipContent: _i18n.i18n.translate('xpack.triggersActionsUI.sections.preconfiguredConnectorForm.tooltipContent', {
      defaultMessage: 'This connector is preconfigured and cannot be edited'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 17
    }
  }, isExperimental && /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _translations.TECH_PREVIEW_LABEL,
    tooltipContent: _translations.TECH_PREVIEW_DESCRIPTION,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "{connectorTypeDesc}",
    id: "xpack.triggersActionsUI.sections.editConnectorForm.actionTypeDescription",
    values: {
      connectorTypeDesc
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 17
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "center",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: "flyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Edit connector",
    id: "xpack.triggersActionsUI.sections.editConnectorForm.flyoutPreconfiguredTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 21
    }
  })))), isExperimental && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _translations.TECH_PREVIEW_LABEL,
    tooltipContent: _translations.TECH_PREVIEW_DESCRIPTION,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    className: "connectorEditFlyoutTabs",
    bottomBorder: false,
    css: (0, _react2.css)`
          margin-bottom: -${euiTheme.size.l};
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: setConfigurationTab,
    "data-test-subj": "configureConnectorTab",
    isSelected: _types.EditConnectorTabs.Configuration === selectedTab,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.editConnectorForm.tabText', {
    defaultMessage: 'Configuration'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: setRulesTab,
    "data-test-subj": "rulesConnectorTab",
    isSelected: _types.EditConnectorTabs.Rules === selectedTab,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesConnectorList.tabText', {
    defaultMessage: 'Rules'
  })), canExecute && /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: setTestTab,
    "data-test-subj": "testConnectorTab",
    isSelected: _types.EditConnectorTabs.Test === selectedTab,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.testConnectorForm.tabText', {
    defaultMessage: 'Test'
  }))));
};
const FlyoutHeader = exports.FlyoutHeader = /*#__PURE__*/(0, _react.memo)(FlyoutHeaderComponent);