"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadRule = loadRule;
var _constants = require("../../constants");
var _common_transformations = require("./common_transformations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function loadRule({
  http,
  ruleId
}) {
  const res = await http.get(`${_constants.INTERNAL_BASE_ALERTING_API_PATH}/rule/${encodeURIComponent(ruleId)}`);
  return (0, _common_transformations.transformRule)(res);
}