"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateActionConnector = updateActionConnector;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rewriteBodyRes = ({
  connector_type_id: actionTypeId,
  is_preconfigured: isPreconfigured,
  is_deprecated: isDeprecated,
  is_missing_secrets: isMissingSecrets,
  is_system_action: isSystemAction,
  is_connector_type_deprecated: isConnectorTypeDeprecated,
  ...res
}) => ({
  ...res,
  actionTypeId,
  isPreconfigured,
  isDeprecated,
  isMissingSecrets,
  isSystemAction,
  isConnectorTypeDeprecated
});
async function updateActionConnector({
  http,
  connector,
  id
}) {
  const res = await http.put(`${_constants.BASE_ACTION_API_PATH}/connector/${encodeURIComponent(id)}`, {
    body: JSON.stringify({
      name: connector.name,
      config: connector.config,
      secrets: connector.secrets
    })
  });
  return rewriteBodyRes(res);
}