"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateApiKeyModalConfirmation = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../common/lib/kibana");
var _use_bulk_edit_response = require("../hooks/use_bulk_edit_response");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/components/update_api_key_modal_confirmation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UpdateApiKeyModalConfirmation = ({
  onCancel,
  idsToUpdate,
  rulesToUpdate,
  idsToUpdateFilter,
  numberOfSelectedRules = 0,
  apiUpdateApiKeyCall,
  setIsLoadingState,
  onUpdated,
  onSearchPopulate
}) => {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const [updateModalFlyoutVisible, setUpdateModalVisibility] = (0, _react.useState)(false);
  const {
    showToast
  } = (0, _use_bulk_edit_response.useBulkEditResponse)({
    onSearchPopulate
  });
  const computedIdsToUpdate = (0, _react.useMemo)(() => {
    if (idsToUpdate !== null && idsToUpdate !== void 0 && idsToUpdate.length) {
      return idsToUpdate;
    }
    if (rulesToUpdate !== null && rulesToUpdate !== void 0 && rulesToUpdate.length) {
      return rulesToUpdate.map(rule => rule.id);
    }
    return [];
  }, [idsToUpdate, rulesToUpdate]);
  (0, _react.useEffect)(() => {
    if (typeof idsToUpdateFilter !== 'undefined') {
      setUpdateModalVisibility(true);
    } else {
      setUpdateModalVisibility(computedIdsToUpdate.length > 0);
    }
  }, [computedIdsToUpdate, idsToUpdateFilter]);
  const numberOfIdsToUpdate = (0, _react.useMemo)(() => {
    if (typeof idsToUpdateFilter !== 'undefined') {
      return numberOfSelectedRules;
    }
    return computedIdsToUpdate.length;
  }, [idsToUpdateFilter, numberOfSelectedRules, computedIdsToUpdate]);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return updateModalFlyoutVisible ? /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    buttonColor: "primary",
    "data-test-subj": "updateApiKeyIdsConfirmation",
    title: _i18n.i18n.translate('xpack.triggersActionsUI.updateApiKeyConfirmModal.title', {
      defaultMessage: 'Update API key'
    }),
    onCancel: () => {
      setUpdateModalVisibility(false);
      onCancel();
    },
    onConfirm: async () => {
      setUpdateModalVisibility(false);
      setIsLoadingState(true);
      try {
        const response = await apiUpdateApiKeyCall({
          ids: computedIdsToUpdate,
          filter: idsToUpdateFilter,
          http
        });
        showToast(response, 'apiKey');
      } catch (e) {
        toasts.addError(e, {
          title: _i18n.i18n.translate('xpack.triggersActionsUI.updateApiKeyConfirmModal.failureMessage', {
            defaultMessage: 'Failed to update the API {idsToUpdate, plural, one {key} other {keys}}',
            values: {
              idsToUpdate: numberOfIdsToUpdate
            }
          })
        });
      }
      setIsLoadingState(false);
      onUpdated();
    },
    cancelButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.updateApiKeyConfirmModal.cancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.updateApiKeyConfirmModal.confirmButton', {
      defaultMessage: 'Update'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.triggersActionsUI.updateApiKeyConfirmModal.description', {
    defaultMessage: 'You will not be able to recover the old API {idsToUpdate, plural, one {key} other {keys}}',
    values: {
      idsToUpdate: numberOfIdsToUpdate
    }
  })) : null;
};
exports.UpdateApiKeyModalConfirmation = UpdateApiKeyModalConfirmation;