"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TextAreaWithAutocomplete = void 0;
var _react = _interopRequireWildcard(require("react"));
var _textareaCaret = _interopRequireDefault(require("textarea-caret"));
var _eui = require("@elastic/eui");
var _alertsUiShared = require("@kbn/alerts-ui-shared");
var _filter_suggestions_for_autocomplete = require("./lib/filter_suggestions_for_autocomplete");
var _template_action_variable = require("./lib/template_action_variable");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/components/text_area_with_autocomplete/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const selectableListProps = {
  className: 'euiSelectableMsgAutoComplete'
};
const TextAreaWithAutocomplete = ({
  editAction,
  errors,
  index,
  inputTargetValue,
  isDisabled = false,
  label,
  messageVariables,
  paramsProperty
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const backgroundColor = euiTheme.colors.backgroundBasePlain;
  const textAreaRef = _react.default.useRef(null);
  const selectableRef = _react.default.useRef(null);
  const [matches, setMatches] = (0, _react.useState)([]);
  const [popupPosition, setPopupPosition] = (0, _react.useState)({
    top: 0,
    left: 0,
    height: 0,
    width: 0
  });
  const [isListOpen, setListOpen] = (0, _react.useState)(false);
  const [autoCompleteIndex, setAutoCompleteIndex] = (0, _react.useState)(-1);
  const [selectableHasFocus, setSelectableHasFocus] = (0, _react.useState)(false);
  const [searchWord, setSearchWord] = (0, _react.useState)('');
  const optionsToShow = (0, _react.useMemo)(() => {
    return matches === null || matches === void 0 ? void 0 : matches.map(variable => ({
      label: variable,
      data: {
        description: variable
      },
      'data-test-subj': `${variable}-selectableOption`
    }));
  }, [matches]);
  const closeList = (0, _react.useCallback)((doNotResetAutoCompleteIndex = false) => {
    if (!doNotResetAutoCompleteIndex) {
      setAutoCompleteIndex(-1);
    }
    setListOpen(false);
    setSelectableHasFocus(false);
  }, []);
  const onOptionPick = (0, _react.useCallback)(newOptions => {
    if (!textAreaRef.current) return;
    const {
      value,
      selectionStart,
      scrollTop
    } = textAreaRef.current;
    const lastSpaceIndex = value.slice(0, selectionStart).lastIndexOf(' ');
    const lastOpenDoubleCurlyBracketsIndex = value.slice(0, selectionStart).lastIndexOf('{{');
    const currentWordStartIndex = Math.max(lastSpaceIndex, lastOpenDoubleCurlyBracketsIndex);
    const checkedElement = newOptions.find(({
      checked
    }) => checked === 'on');
    if (checkedElement) {
      const newInputText = value.slice(0, currentWordStartIndex) + '{{' + checkedElement.label + '}}' + value.slice(selectionStart);
      editAction(paramsProperty, newInputText.trim(), index);
      setMatches([]);
      closeList();
      textAreaRef.current.focus();
      // We use setTimeout here, because editAction is async function and we need to wait before it executes
      setTimeout(() => {
        if (textAreaRef.current) {
          textAreaRef.current.selectionStart = currentWordStartIndex + checkedElement.label.length + 4;
          textAreaRef.current.selectionEnd = textAreaRef.current.selectionStart;
          textAreaRef.current.scrollTop = scrollTop;
        }
      }, 0);
    }
  }, [editAction, index, paramsProperty, closeList]);
  const recalcMenuPosition = (0, _react.useCallback)(() => {
    var _textAreaRef$current;
    if (!textAreaRef.current) return;
    const newPosition = (0, _textareaCaret.default)(textAreaRef.current, textAreaRef.current.selectionStart);
    const textAreaClientRect = (_textAreaRef$current = textAreaRef.current) === null || _textAreaRef$current === void 0 ? void 0 : _textAreaRef$current.getBoundingClientRect();
    const top = textAreaClientRect.top - textAreaRef.current.scrollTop + window.scrollY + newPosition.top + newPosition.height;
    const left = textAreaClientRect.left + window.pageXOffset;
    const height = newPosition.height;
    const width = textAreaClientRect.width;
    setPopupPosition({
      top,
      left,
      width,
      height
    });
    setListOpen(true);
  }, []);
  const onChangeWithMessageVariable = (0, _react.useCallback)(() => {
    if (!textAreaRef.current) return;
    const {
      value,
      selectionStart
    } = textAreaRef.current;
    const lastTwoLetter = value.slice(selectionStart - 2, selectionStart);
    const currentWord = autoCompleteIndex !== -1 ? value.slice(autoCompleteIndex, selectionStart) : '';
    if (lastTwoLetter === '{{' || currentWord.startsWith('{{')) {
      if (lastTwoLetter === '{{') {
        setAutoCompleteIndex(selectionStart - 2);
      }
      const filteredMatches = (0, _filter_suggestions_for_autocomplete.filterSuggestions)({
        actionVariablesList: messageVariables === null || messageVariables === void 0 ? void 0 : messageVariables.filter(({
          deprecated
        }) => !deprecated).map(({
          name
        }) => name),
        propertyPath: currentWord.slice(2)
      });
      setSearchWord(currentWord.slice(2));
      setMatches(filteredMatches);
      setTimeout(() => recalcMenuPosition(), 0);
    } else if (lastTwoLetter === '}}') {
      closeList();
    } else {
      setMatches([]);
    }
    editAction(paramsProperty, value, index);
  }, [autoCompleteIndex, closeList, editAction, index, messageVariables, paramsProperty, recalcMenuPosition]);
  const textareaOnKeyPress = (0, _react.useCallback)(event => {
    if (selectableRef.current && isListOpen) {
      if (!selectableHasFocus && (event.code === 'ArrowUp' || event.code === 'ArrowDown')) {
        event.preventDefault();
        event.stopPropagation();
        selectableRef.current.onFocus();
        setSelectableHasFocus(true);
      } else if (event.code === 'ArrowUp') {
        event.preventDefault();
        event.stopPropagation();
        selectableRef.current.incrementActiveOptionIndex(-1);
      } else if (event.code === 'ArrowDown') {
        event.preventDefault();
        event.stopPropagation();
        selectableRef.current.incrementActiveOptionIndex(1);
      } else if (event.code === 'Escape') {
        event.preventDefault();
        event.stopPropagation();
        closeList();
      } else if (event.code === 'Enter' || event.code === 'Space') {
        const optionIndex = selectableRef.current.state.activeOptionIndex;
        onOptionPick(optionsToShow.map((ots, idx) => {
          if (idx === optionIndex) {
            return {
              ...ots,
              checked: 'on'
            };
          }
          return ots;
        }));
        closeList();
      }
    } else {
      setSelectableHasFocus(prevValue => {
        if (prevValue) {
          return false;
        }
        return prevValue;
      });
    }
  }, [closeList, isListOpen, onOptionPick, optionsToShow, selectableHasFocus]);
  const clickOutSideTextArea = (0, _react.useCallback)(event => {
    var _document$querySelect;
    const box = ((_document$querySelect = document.querySelector('.euiSelectableMsgAutoComplete')) === null || _document$querySelect === void 0 ? void 0 : _document$querySelect.getBoundingClientRect()) || {
      left: 0,
      right: 0,
      top: 0,
      bottom: 0
    };
    if (event.clientX > box.left && event.clientX < box.right && event.clientY > box.top && event.clientY < box.bottom) {
      return;
    }
    closeList();
  }, [closeList]);
  const onSelectMessageVariable = (0, _react.useCallback)(variable => {
    if (!textAreaRef.current) return;
    const {
      selectionStart: startPosition,
      selectionEnd: endPosition
    } = textAreaRef.current;
    const templatedVar = (0, _template_action_variable.templateActionVariable)(variable);
    const newValue = (inputTargetValue !== null && inputTargetValue !== void 0 ? inputTargetValue : '').substring(0, startPosition) + templatedVar + (inputTargetValue !== null && inputTargetValue !== void 0 ? inputTargetValue : '').substring(endPosition, (inputTargetValue !== null && inputTargetValue !== void 0 ? inputTargetValue : '').length);
    editAction(paramsProperty, newValue, index);
  }, [editAction, index, inputTargetValue, paramsProperty]);
  const renderSelectableOption = option => {
    if (searchWord) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
        search: searchWord,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 260,
          columnNumber: 14
        }
      }, option.label);
    }
    return option.label;
  };
  const selectableStyle = (0, _react.useMemo)(() => ({
    position: 'absolute',
    top: popupPosition.top,
    width: popupPosition.width,
    left: popupPosition.left,
    border: `${euiTheme.border.width.thin} solid ${euiTheme.border.color}`,
    background: backgroundColor,
    zIndex: euiTheme.levels.flyout
  }), [backgroundColor, euiTheme.border.color, euiTheme.border.width.thin, euiTheme.levels.flyout, popupPosition.left, popupPosition.top, popupPosition.width]);
  const onFocus = (0, _react.useCallback)(() => setListOpen(true), []);
  const onBlur = (0, _react.useCallback)(() => {
    if (!inputTargetValue && !isListOpen) {
      editAction(paramsProperty, '', index);
    }
  }, [editAction, index, inputTargetValue, isListOpen, paramsProperty]);
  const onClick = (0, _react.useCallback)(() => closeList(), [closeList]);
  const onScroll = (0, _react.useCallback)(evt => {
    var _selectableRef$curren, _evt$target, _evt$target$firstElem;
    // FUTURE ENGINEER -> we need to make sure to not close the autocomplete option list
    if ((selectableRef === null || selectableRef === void 0 ? void 0 : (_selectableRef$curren = selectableRef.current) === null || _selectableRef$curren === void 0 ? void 0 : _selectableRef$curren.listId) !== ((_evt$target = evt.target) === null || _evt$target === void 0 ? void 0 : (_evt$target$firstElem = _evt$target.firstElementChild) === null || _evt$target$firstElem === void 0 ? void 0 : _evt$target$firstElem.id)) {
      closeList(true);
    }
  }, [closeList]);
  (0, _react.useEffect)(() => {
    window.addEventListener('scroll', onScroll, {
      passive: true,
      capture: true
    });
    return () => {
      window.removeEventListener('scroll', onScroll, {
        capture: true
      });
    };
  }, [onScroll]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: errors,
    fullWidth: true,
    isDisabled: isDisabled,
    isInvalid: errors && errors.length > 0 && inputTargetValue !== undefined,
    label: label,
    labelAppend: /*#__PURE__*/_react.default.createElement(_alertsUiShared.AddMessageVariables, {
      messageVariables: messageVariables,
      onSelectEventHandler: onSelectMessageVariable,
      paramsProperty: paramsProperty,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 318,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: clickOutSideTextArea,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    disabled: isDisabled,
    inputRef: textAreaRef,
    fullWidth: true,
    isInvalid: errors && errors.length > 0 && inputTargetValue !== undefined,
    name: paramsProperty,
    value: inputTargetValue || '',
    "data-test-subj": `${paramsProperty}TextArea`,
    onChange: onChangeWithMessageVariable,
    onFocus: onFocus,
    onKeyDown: textareaOnKeyPress,
    onBlur: onBlur,
    onClick: onClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 327,
      columnNumber: 11
    }
  })), matches.length > 0 && isListOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    ref: selectableRef,
    style: selectableStyle,
    height: matches.length > 5 ? 32 * 5.5 : matches.length * 32,
    options: optionsToShow,
    onChange: onOptionPick,
    singleSelection: true,
    renderOption: renderSelectableOption,
    listProps: selectableListProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 344,
      columnNumber: 13
    }
  }, list => list))));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.TextAreaWithAutocomplete = TextAreaWithAutocomplete;