"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonFieldWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _react = _interopRequireWildcard(require("react"));
var _json_field_wrapper = require("./json_field_wrapper.styles");
var _json_editor_with_message_variables = require("./json_editor_with_message_variables");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/triggers_actions_ui/public/application/components/json_field_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JsonFieldWrapper = ({
  field,
  ...rest
}) => {
  const {
    errorMessage
  } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
  const {
    label,
    helpText,
    value,
    setValue
  } = field;
  const onJsonUpdate = (0, _react.useCallback)(updatedJson => {
    setValue(updatedJson);
  }, [setValue]);
  return /*#__PURE__*/_react.default.createElement("span", {
    css: _json_field_wrapper.styles.editor,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_json_editor_with_message_variables.JsonEditorWithMessageVariables, (0, _extends2.default)({
    errors: errorMessage ? [errorMessage] : [],
    helpText: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 19
      }
    }, helpText),
    inputTargetValue: value,
    label: label !== null && label !== void 0 ? label : _i18n.i18n.translate('xpack.triggersActionsUI.jsonFieldWrapper.defaultLabel', {
      defaultMessage: 'JSON Editor'
    }),
    onDocumentsChange: onJsonUpdate
  }, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  })));
};
exports.JsonFieldWrapper = JsonFieldWrapper;