"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransformServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _usage = require("./usage");
var _capabilities = require("./capabilities");
var _routes = require("./routes");
var _services = require("./services");
var _alerting = require("./lib/alerting");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const basicLicense = 'basic';
const PLUGIN = {
  id: 'transform',
  minimumLicenseType: basicLicense,
  getI18nName: () => _i18n.i18n.translate('xpack.transform.appTitle', {
    defaultMessage: 'Transforms'
  })
};
class TransformServerPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "fieldFormatsStart", null);
    this.logger = initContext.logger.get();
  }
  setup(coreSetup, {
    licensing,
    features,
    alerting,
    security: securitySetup,
    usageCollection
  }) {
    const {
      http,
      getStartServices
    } = coreSetup;
    (0, _capabilities.setupCapabilities)(coreSetup, securitySetup);
    features.registerElasticsearchFeature({
      id: PLUGIN.id,
      management: {
        data: [PLUGIN.id]
      },
      catalogue: [PLUGIN.id],
      privileges: [{
        requiredClusterPrivileges: ['monitor_transform'],
        ui: []
      }]
    });
    (0, _routes.registerRoutes)({
      router: http.createRouter(),
      getLicense: async () => {
        const [coreStart] = await getStartServices();
        return new _services.License({
          pluginId: PLUGIN.id,
          minimumLicenseType: PLUGIN.minimumLicenseType,
          defaultErrorMessage: _i18n.i18n.translate('xpack.transform.licenseCheckErrorMessage', {
            defaultMessage: 'License check failed'
          }),
          licensing,
          logger: this.logger,
          coreStart
        });
      },
      getDataViewsStart: async () => {
        const [, {
          dataViews
        }] = await getStartServices();
        return dataViews;
      },
      getCoreStart: async () => {
        const [coreStart] = await getStartServices();
        return coreStart;
      },
      getSecurity: async () => {
        const [, {
          security
        }] = await getStartServices();
        return security;
      }
    });
    if (usageCollection) {
      (0, _usage.registerCollector)(usageCollection, async () => {
        const [coreStart] = await getStartServices();
        return coreStart.savedObjects.getIndexForType('alert');
      });
    }
    if (alerting) {
      (0, _alerting.registerTransformHealthRuleType)({
        alerting,
        logger: this.logger,
        getFieldFormatsStart: () => this.fieldFormatsStart
      });
    }
    return {};
  }
  start(core, plugins) {
    this.fieldFormatsStart = plugins.fieldFormats;
  }
  stop() {}
}
exports.TransformServerPlugin = TransformServerPlugin;