"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../hooks");
var _reauthorization_utils = require("../../../../common/reauthorization_utils");
var _transform = require("../../../../../../common/types/transform");
var _constants = require("../../../../../../common/constants");
var _common = require("../../../../common");
var _use_actions = require("./use_actions");
var _managed_transforms_utils = require("../../../../common/managed_transforms_utils");
var _transform_health_colored_dot = require("./transform_health_colored_dot");
var _transform_task_state_badge = require("./transform_task_state_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/transform/public/app/sections/transform_management/components/transform_list/use_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TRUNCATE_TEXT_LINES = 3;
const TRANSFORM_INSUFFICIENT_PERMISSIONS_MSG = _i18n.i18n.translate('xpack.transform.transformList.needsReauthorizationBadge.insufficientPermissions', {
  defaultMessage: 'This transform was created with insufficient permissions.'
});
const StatsUnknown = () => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  textAlign: "center",
  color: "subdued",
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 57,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.transform.transformList.statsUnknown",
  defaultMessage: "Unknown",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 58,
    columnNumber: 5
  }
}));
const useColumns = (expandedRowItemIds, setExpandedRowItemIds, transformNodes, transformSelection, transformsStatsLoading) => {
  const NoStatsFallbackComponent = transformsStatsLoading ? _eui.EuiLoadingSpinner : StatsUnknown;
  const {
    canStartStopTransform
  } = (0, _hooks.useTransformCapabilities)();
  const {
    actions,
    modals
  } = (0, _use_actions.useActions)({
    forceDisable: transformSelection.length > 0,
    transformNodes
  });
  function toggleDetails(item) {
    const index = expandedRowItemIds.indexOf(item.config.id);
    if (index !== -1) {
      expandedRowItemIds.splice(index, 1);
      setExpandedRowItemIds([...expandedRowItemIds]);
    } else {
      expandedRowItemIds.push(item.config.id);
    }

    // spread to a new array otherwise the component wouldn't re-render
    setExpandedRowItemIds([...expandedRowItemIds]);
  }
  const columns = [{
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.transformList.showDetailsColumn.screenReaderDescription",
      defaultMessage: "This column contains clickable controls for showing more details on each transform",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 13
      }
    }))),
    align: _eui.RIGHT_ALIGNMENT,
    width: '40px',
    isExpander: true,
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: () => toggleDetails(item),
      "aria-label": expandedRowItemIds.includes(item.config.id) ? _i18n.i18n.translate('xpack.transform.transformList.rowCollapse', {
        defaultMessage: 'Hide details for {transformId}',
        values: {
          transformId: item.config.id
        }
      }) : _i18n.i18n.translate('xpack.transform.transformList.rowExpand', {
        defaultMessage: 'Show details for {transformId}',
        values: {
          transformId: item.config.id
        }
      }),
      iconType: expandedRowItemIds.includes(item.config.id) ? 'arrowDown' : 'arrowRight',
      "data-test-subj": "transformListRowDetailsToggle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 9
      }
    })
  }, {
    field: _common.TRANSFORM_LIST_COLUMN.ID,
    'data-test-subj': 'transformListColumnId',
    name: 'ID',
    sortable: true,
    truncateText: {
      lines: TRUNCATE_TEXT_LINES
    },
    scope: 'row',
    render: (transformId, item) => {
      if (!(0, _managed_transforms_utils.isManagedTransform)(item)) return /*#__PURE__*/_react.default.createElement("span", {
        title: transformId,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 47
        }
      }, transformId);
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
        title: `${transformId} (${_i18n.i18n.translate('xpack.transform.transformList.managedBadgeLabel', {
          defaultMessage: 'Managed'
        })})`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 145,
          columnNumber: 13
        }
      }, transformId), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _i18n.i18n.translate('xpack.transform.transformList.managedBadgeTooltip', {
          defaultMessage: 'This transform is preconfigured and managed by Elastic; other parts of the product might have might have dependencies on its behavior.'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        tabIndex: 0,
        color: "hollow",
        "data-test-subj": "transformListRowIsManagedBadge",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 162,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.transform.transformList.managedBadgeLabel', {
        defaultMessage: 'Managed'
      }))));
    }
  }, {
    id: 'alertRule',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.transformList.alertingRules.screenReaderDescription",
      defaultMessage: "This column displays an icon when there are alert rules associated with a transform",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 13
      }
    }))),
    width: '30px',
    render: item => {
      const needsReauth = (0, _reauthorization_utils.needsReauthorization)(item);
      const actionMsg = canStartStopTransform ? _i18n.i18n.translate('xpack.transform.transformList.needsReauthorizationBadge.reauthorizeTooltip', {
        defaultMessage: 'Reauthorize to start transforms.'
      }) : _i18n.i18n.translate('xpack.transform.transformList.needsReauthorizationBadge.contactAdminTooltip', {
        defaultMessage: 'Contact your administrator to request the required permissions.'
      });
      const needsReauthTooltipIcon = needsReauth ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: `${TRANSFORM_INSUFFICIENT_PERMISSIONS_MSG} ${actionMsg}`,
        type: "alert",
        size: "s",
        color: "warning",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 203,
          columnNumber: 13
        }
      }), "\xA0") : null;
      const alertingRulesTooltipIcon = Array.isArray(item.alerting_rules) ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        position: "bottom",
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.transform.transformList.alertingRules.tooltipContent",
          defaultMessage: "Transform has {rulesCount} associated alert {rulesCount, plural, one { rule} other { rules}}",
          values: {
            rulesCount: item.alerting_rules.length
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 217,
            columnNumber: 15
          }
        }),
        type: "bell",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 214,
          columnNumber: 11
        }
      }) : /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 226,
          columnNumber: 11
        }
      });
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, needsReauthTooltipIcon, alertingRulesTooltipIcon);
    }
  }, {
    field: _common.TRANSFORM_LIST_COLUMN.DESCRIPTION,
    'data-test-subj': 'transformListColumnDescription',
    name: _i18n.i18n.translate('xpack.transform.description', {
      defaultMessage: 'Description'
    }),
    sortable: true,
    truncateText: {
      lines: TRUNCATE_TEXT_LINES
    },
    render(text) {
      return /*#__PURE__*/_react.default.createElement("span", {
        title: text,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 243,
          columnNumber: 16
        }
      }, text);
    }
  }, {
    name: _i18n.i18n.translate('xpack.transform.type', {
      defaultMessage: 'Type'
    }),
    'data-test-subj': 'transformListColumnType',
    sortable: item => item.mode,
    truncateText: true,
    render(item) {
      let transformType = _i18n.i18n.translate('xpack.transform.type.unknown', {
        defaultMessage: 'unknown'
      });
      if ((0, _transform.isPivotTransform)(item.config) === true) {
        transformType = _i18n.i18n.translate('xpack.transform.type.pivot', {
          defaultMessage: 'pivot'
        });
      }
      if ((0, _transform.isLatestTransform)(item.config) === true) {
        transformType = _i18n.i18n.translate('xpack.transform.type.latest', {
          defaultMessage: 'latest'
        });
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 263,
          columnNumber: 16
        }
      }, transformType);
    },
    width: '100px'
  }, {
    name: _i18n.i18n.translate('xpack.transform.status', {
      defaultMessage: 'Status'
    }),
    'data-test-subj': 'transformListColumnStatus',
    sortable: item => {
      var _item$stats;
      return (_item$stats = item.stats) === null || _item$stats === void 0 ? void 0 : _item$stats.state;
    },
    truncateText: true,
    render(item) {
      return item.stats ? /*#__PURE__*/_react.default.createElement(_transform_task_state_badge.TransformTaskStateBadge, {
        state: item.stats.state,
        reason: item.stats.reason,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 274,
          columnNumber: 11
        }
      }) : /*#__PURE__*/_react.default.createElement(NoStatsFallbackComponent, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 276,
          columnNumber: 11
        }
      });
    },
    width: '100px'
  }, {
    name: _i18n.i18n.translate('xpack.transform.mode', {
      defaultMessage: 'Mode'
    }),
    'data-test-subj': 'transformListColumnMode',
    sortable: item => item.mode,
    truncateText: true,
    render(item) {
      const mode = item.mode;
      const color = 'hollow';
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: color,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 289,
          columnNumber: 16
        }
      }, mode);
    },
    width: '100px'
  }, {
    name: _i18n.i18n.translate('xpack.transform.progress', {
      defaultMessage: 'Progress'
    }),
    'data-test-subj': 'transformListColumnProgress',
    sortable: item => (0, _common.getTransformProgress)(item) || 0,
    truncateText: true,
    render(item) {
      const progress = (0, _common.getTransformProgress)(item);
      const isBatchTransform = typeof item.config.sync === 'undefined';
      if (progress === undefined && isBatchTransform === true) {
        return null;
      }
      if (!item.stats) return /*#__PURE__*/_react.default.createElement(NoStatsFallbackComponent, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 306,
          columnNumber: 33
        }
      });
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 309,
          columnNumber: 11
        }
      }, isBatchTransform && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        style: {
          width: '40px'
        },
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 312,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
        value: progress,
        max: 100,
        color: "primary",
        size: "m",
        "data-test-subj": "transformListProgress",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 313,
          columnNumber: 19
        }
      }, progress, "%")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        style: {
          width: '35px'
        },
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 323,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 324,
          columnNumber: 19
        }
      }, `${progress}%`))), !isBatchTransform && item.stats && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        style: {
          width: '40px'
        },
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 330,
          columnNumber: 17
        }
      }, item.stats.state !== _constants.TRANSFORM_STATE.STOPPED && item.stats.state !== _constants.TRANSFORM_STATE.WAITING && item.stats.state !== _constants.TRANSFORM_STATE.FAILED && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
        color: "primary",
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 335,
          columnNumber: 23
        }
      }), (item.stats.state === _constants.TRANSFORM_STATE.STOPPED || item.stats.state === _constants.TRANSFORM_STATE.WAITING || item.stats.state === _constants.TRANSFORM_STATE.FAILED) && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
        value: 0,
        max: 100,
        color: "primary",
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 341,
          columnNumber: 21
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        style: {
          width: '35px'
        },
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 344,
          columnNumber: 17
        }
      }, "\xA0")));
    },
    width: '100px'
  }, {
    name: _i18n.i18n.translate('xpack.transform.health', {
      defaultMessage: 'Health'
    }),
    'data-test-subj': 'transformListColumnHealth',
    sortable: item => {
      var _item$stats2, _item$stats2$health;
      return (_item$stats2 = item.stats) === null || _item$stats2 === void 0 ? void 0 : (_item$stats2$health = _item$stats2.health) === null || _item$stats2$health === void 0 ? void 0 : _item$stats2$health.status;
    },
    truncateText: true,
    render(item) {
      var _item$stats3;
      return (_item$stats3 = item.stats) !== null && _item$stats3 !== void 0 && _item$stats3.health ? /*#__PURE__*/_react.default.createElement(_transform_health_colored_dot.TransformHealthColoredDot, {
        healthStatus: (0, _constants.mapEsHealthStatus2TransformHealthStatus)(item.stats.health.status),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 361,
          columnNumber: 11
        }
      }) : /*#__PURE__*/_react.default.createElement(NoStatsFallbackComponent, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 365,
          columnNumber: 11
        }
      });
    },
    width: '100px'
  }, {
    name: _i18n.i18n.translate('xpack.transform.tableActionLabel', {
      defaultMessage: 'Actions'
    }),
    actions: actions,
    width: '80px'
  }];
  return {
    columns,
    modals
  };
};
exports.useColumns = useColumns;