"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startActionNameText = exports.isStartActionDisabled = exports.StartActionName = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _create_stats_unknown_message = require("../../../../../../common/utils/create_stats_unknown_message");
var _transform_list = require("../../../../common/transform_list");
var _constants = require("../../../../../../common/constants");
var _create_capability_failure_message = require("../../../../../../common/utils/create_capability_failure_message");
var _hooks = require("../../../../hooks");
var _common = require("../../../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/transform/public/app/sections/transform_management/components/action_start/start_action_name.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const startActionNameText = exports.startActionNameText = _i18n.i18n.translate('xpack.transform.transformList.startActionNameText', {
  defaultMessage: 'Start'
});
const isStartActionDisabled = (items, canStartStopTransform, transformNodes) => {
  // Disable start for batch transforms which have completed.
  const completedBatchTransform = items.some(i => (0, _common.isCompletedBatchTransform)(i));
  // Disable start action if one of the transforms is already started or trying to restart will throw error
  const startedTransform = items.some(i => {
    var _i$stats;
    return ((_i$stats = i.stats) === null || _i$stats === void 0 ? void 0 : _i$stats.state) === _constants.TRANSFORM_STATE.STARTED;
  });
  return !canStartStopTransform || completedBatchTransform || startedTransform || items.length === 0 || transformNodes === 0 || (0, _transform_list.missingTransformStats)(items);
};
exports.isStartActionDisabled = isStartActionDisabled;
const StartActionName = ({
  items,
  forceDisable,
  transformNodes
}) => {
  const {
    canStartStopTransform
  } = (0, _hooks.useTransformCapabilities)();
  const isBulkAction = items.length > 1;

  // Disable start for batch transforms which have completed.
  const completedBatchTransform = items.some(i => (0, _common.isCompletedBatchTransform)(i));
  // Disable if one of the transforms is already started or trying to restart will throw error
  const startedTransform = items.some(i => {
    var _i$stats2;
    return ((_i$stats2 = i.stats) === null || _i$stats2 === void 0 ? void 0 : _i$stats2.state) === _constants.TRANSFORM_STATE.STARTED;
  });
  let startedTransformMessage;
  let completedBatchTransformMessage;
  if (isBulkAction === true) {
    startedTransformMessage = _i18n.i18n.translate('xpack.transform.transformList.startedTransformBulkToolTip', {
      defaultMessage: 'One or more transforms are already started.'
    });
    completedBatchTransformMessage = _i18n.i18n.translate('xpack.transform.transformList.cannotRestartCompleteBatchTransformBulkActionToolTip', {
      defaultMessage: 'One or more transforms are completed batch transforms and cannot be restarted.'
    });
  } else {
    startedTransformMessage = _i18n.i18n.translate('xpack.transform.transformList.startedTransformToolTip', {
      defaultMessage: '{transformId} is already started.',
      values: {
        transformId: items[0] && items[0].config.id
      }
    });
    completedBatchTransformMessage = _i18n.i18n.translate('xpack.transform.transformList.cannotRestartCompleteBatchTransformToolTip', {
      defaultMessage: '{transformId} is a completed batch transform and cannot be restarted.',
      values: {
        transformId: items[0] && items[0].config.id
      }
    });
  }
  const actionIsDisabled = isStartActionDisabled(items, canStartStopTransform, transformNodes);
  let content;
  if (actionIsDisabled && items.length > 0) {
    if (!canStartStopTransform) {
      content = (0, _create_capability_failure_message.createCapabilityFailureMessage)('canStartStopTransform');
    } else if (completedBatchTransform) {
      content = completedBatchTransformMessage;
    } else if (startedTransform) {
      content = startedTransformMessage;
    } else if ((0, _transform_list.missingTransformStats)(items)) {
      content = (0, _create_stats_unknown_message.createNoStatsTooltipMessage)({
        actionName: startActionNameText,
        count: items.length
      });
    }
  }
  if ((forceDisable === true || actionIsDisabled) && content !== undefined) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: content,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 9
      }
    }, startActionNameText));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, startActionNameText);
};
exports.StartActionName = StartActionName;