"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsFormValid = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _reactRedux = require("react-redux");
var _form_field = require("./form_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Checks each form field for error messages to return
// if the overall form is valid or not.
const isFormValid = formFields => Object.values(formFields).every(d => d.errorMessages.length === 0);
const selectIsFormValid = (0, _toolkit.createSelector)(_form_field.selectFormFields, isFormValid);
const useIsFormValid = () => (0, _reactRedux.useSelector)(selectIsFormValid);
exports.useIsFormValid = useIsFormValid;