"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditTransformRetentionPolicy = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _transform = require("../../../../../common/types/transform");
var _errors = require("../../../../../common/utils/errors");
var _app_dependencies = require("../../../app_dependencies");
var _hooks = require("../../../hooks");
var _components = require("../../../components");
var _edit_transform_flyout_state = require("../state_management/edit_transform_flyout_state");
var _form_sections = require("../state_management/selectors/form_sections");
var _retention_policy_field = require("../state_management/selectors/retention_policy_field");
var _edit_transform_flyout_form_text_input = require("./edit_transform_flyout_form_text_input");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/transform/public/app/sections/edit_transform/components/edit_transform_retention_policy.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditTransformRetentionPolicy = () => {
  const startServices = (0, _app_dependencies.useAppDependencies)();
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  const {
    config,
    dataViewId
  } = (0, _edit_transform_flyout_state.useEditTransformFlyoutContext)();
  const formSections = (0, _form_sections.useFormSections)();
  const retentionPolicyField = (0, _retention_policy_field.useRetentionPolicyField)();
  const {
    setFormField,
    setFormSection
  } = (0, _edit_transform_flyout_state.useEditTransformFlyoutActions)();
  const previewRequest = (0, _react.useMemo)(() => {
    return {
      source: config.source,
      ...((0, _transform.isPivotTransform)(config) ? {
        pivot: config.pivot
      } : {}),
      ...((0, _transform.isLatestTransform)(config) ? {
        latest: config.latest
      } : {})
    };
  }, [config]);
  const {
    error: transformsPreviewError,
    data: transformPreview
  } = (0, _hooks.useGetTransformsPreview)(previewRequest);
  const destIndexAvailableTimeFields = (0, _react.useMemo)(() => {
    if (transformPreview !== null && transformPreview !== void 0 && transformPreview.generated_dest_index) {
      const properties = transformPreview.generated_dest_index.mappings.properties;
      const timeFields = Object.keys(properties).filter(col => properties[col].type === 'date');
      return timeFields;
    }
    return [];
  }, [transformPreview]);
  (0, _react.useEffect)(() => {
    if (transformsPreviewError !== null) {
      toastNotifications.addDanger({
        title: _i18n.i18n.translate('xpack.transform.transformList.errorGettingTransformPreview', {
          defaultMessage: 'An error occurred fetching the transform preview'
        }),
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_components.ToastNotificationText, {
          text: (0, _errors.getErrorMessage)(transformsPreviewError),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 72,
            columnNumber: 11
          }
        }), startServices)
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [transformsPreviewError]);
  const isRetentionPolicyAvailable = destIndexAvailableTimeFields.length > 0;
  const retentionDateFieldOptions = (0, _react.useMemo)(() => {
    return Array.isArray(destIndexAvailableTimeFields) ? destIndexAvailableTimeFields.map(text => ({
      text,
      value: text
    })) : [];
  }, [destIndexAvailableTimeFields]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: isRetentionPolicyAvailable === false ? _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormEetentionPolicyError', {
      defaultMessage: 'Retention policy settings are not available for indices without date fields.'
    }) : '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "transformEditRetentionPolicySwitch",
    label: _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormRetentionPolicySwitchLabel', {
      defaultMessage: 'Retention policy'
    }),
    checked: formSections.retentionPolicy.enabled,
    onChange: e => setFormSection({
      section: 'retentionPolicy',
      enabled: e.target.checked
    }),
    disabled: !isRetentionPolicyAvailable,
    "data-test-subj": "transformEditRetentionPolicySwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  })), formSections.retentionPolicy.enabled && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "transformEditRetentionPolicyContent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }),
  // If data view or date fields info not available
  // gracefully defaults to text input
  dataViewId ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormRetentionPolicyFieldLabel', {
      defaultMessage: 'Field'
    }),
    isInvalid: retentionPolicyField.errorMessages.length > 0,
    error: retentionPolicyField.errorMessages,
    helpText: _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormRetentionPolicyDateFieldHelpText', {
      defaultMessage: 'Select the date field that can be used to identify out of date documents in the destination index.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    isInvalid: retentionPolicyField.errorMessages.length > 0,
    "aria-label": _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormRetentionPolicyFieldSelectAriaLabel', {
      defaultMessage: 'Date field to set retention policy'
    }),
    "data-test-subj": "transformEditFlyoutRetentionPolicyFieldSelect",
    options: retentionDateFieldOptions,
    value: retentionPolicyField.value,
    onChange: e => setFormField({
      field: 'retentionPolicyField',
      value: e.target.value
    }),
    hasNoInitialSelection: !retentionDateFieldOptions.map(d => d.text).includes(retentionPolicyField.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 17
    }
  })) : /*#__PURE__*/_react.default.createElement(_edit_transform_flyout_form_text_input.EditTransformFlyoutFormTextInput, {
    field: "retentionPolicyField",
    label: _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormRetentionPolicyFieldLabel', {
      defaultMessage: 'Field'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_edit_transform_flyout_form_text_input.EditTransformFlyoutFormTextInput, {
    field: "retentionPolicyMaxAge",
    label: _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormRetentionPolicyMaxAgeLabel', {
      defaultMessage: 'Max age'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 11
    }
  })));
};
exports.EditTransformRetentionPolicy = EditTransformRetentionPolicy;