"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditTransformFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _managed_transforms_utils = require("../../../common/managed_transforms_utils");
var _managed_transforms_callout = require("../../transform_management/components/managed_transforms_callout/managed_transforms_callout");
var _edit_transform_flyout_state = require("../state_management/edit_transform_flyout_state");
var _edit_transform_api_error_callout = require("./edit_transform_api_error_callout");
var _edit_transform_flyout_callout = require("./edit_transform_flyout_callout");
var _edit_transform_flyout_form = require("./edit_transform_flyout_form");
var _edit_transform_update_button = require("./edit_transform_update_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/transform/public/app/sections/edit_transform/components/edit_transform_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EditTransformFlyout = ({
  closeFlyout,
  config,
  dataViewId,
  isFlyoutVisible
}) => config && isFlyoutVisible ? /*#__PURE__*/_react.default.createElement(_edit_transform_flyout_state.EditTransformFlyoutProvider, {
  config: config,
  dataViewId: dataViewId,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 42,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
  onClose: closeFlyout,
  hideCloseButton: true,
  "aria-labelledby": "transformEditFlyoutTitle",
  "data-test-subj": "transformEditFlyout",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 43,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
  hasBorder: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 49,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "m",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 50,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement("h2", {
  id: "transformEditFlyoutTitle",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 51,
    columnNumber: 13
  }
}, _i18n.i18n.translate('xpack.transform.transformList.editFlyoutTitle', {
  defaultMessage: 'Edit {transformId}',
  values: {
    transformId: config.id
  }
})))), (0, _managed_transforms_utils.isManagedTransform)({
  config
}) ? /*#__PURE__*/_react.default.createElement(_managed_transforms_callout.ManagedTransformsWarningCallout, {
  count: 1,
  action: _i18n.i18n.translate('xpack.transform.transformList.editManagedTransformsDescription', {
    defaultMessage: 'editing'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 62,
    columnNumber: 11
  }
}) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
  banner: /*#__PURE__*/_react.default.createElement(_edit_transform_flyout_callout.EditTransformFlyoutCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 32
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 72,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_edit_transform_flyout_form.EditTransformFlyoutForm, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 73,
    columnNumber: 11
  }
}), /*#__PURE__*/_react.default.createElement(_edit_transform_api_error_callout.EditTransformApiErrorCallout, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 74,
    columnNumber: 11
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 76,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "spaceBetween",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 77,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 78,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  iconType: "cross",
  onClick: closeFlyout,
  flush: "left",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 79,
    columnNumber: 15
  }
}, _i18n.i18n.translate('xpack.transform.transformList.editFlyoutCancelButtonText', {
  defaultMessage: 'Cancel'
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 85,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_edit_transform_update_button.EditTransformUpdateButton, {
  closeFlyout: closeFlyout,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 86,
    columnNumber: 15
  }
})))))) : null;
exports.EditTransformFlyout = EditTransformFlyout;