"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyTransformConfigToDetailsState = applyTransformConfigToDetailsState;
exports.getDefaultStepDetailsState = getDefaultStepDetailsState;
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDefaultStepDetailsState() {
  return {
    continuousModeDateField: '',
    continuousModeDelay: _constants.DEFAULT_CONTINUOUS_MODE_DELAY,
    createDataView: true,
    isContinuousModeEnabled: false,
    isRetentionPolicyEnabled: false,
    retentionPolicyDateField: '',
    retentionPolicyMaxAge: '',
    transformId: '',
    transformDescription: '',
    transformFrequency: _constants.DEFAULT_TRANSFORM_FREQUENCY,
    transformSettingsMaxPageSearchSize: _constants.DEFAULT_TRANSFORM_SETTINGS_MAX_PAGE_SEARCH_SIZE,
    transformSettingsDocsPerSecond: _constants.DEFAULT_TRANSFORM_SETTINGS_DOCS_PER_SECOND,
    transformSettingsNumFailureRetries: undefined,
    destinationIndex: '',
    destinationIngestPipeline: '',
    touched: false,
    valid: false,
    dataViewTimeField: undefined
  };
}
function applyTransformConfigToDetailsState(state, transformConfig) {
  // apply the transform configuration to wizard DETAILS state
  if (transformConfig !== undefined) {
    var _transformConfig$sync, _transformConfig$rete;
    // Continuous mode
    const continuousModeTime = (_transformConfig$sync = transformConfig.sync) === null || _transformConfig$sync === void 0 ? void 0 : _transformConfig$sync.time;
    if (continuousModeTime !== undefined) {
      var _continuousModeTime$d;
      state.continuousModeDateField = continuousModeTime.field;
      state.continuousModeDelay = (_continuousModeTime$d = continuousModeTime === null || continuousModeTime === void 0 ? void 0 : continuousModeTime.delay) !== null && _continuousModeTime$d !== void 0 ? _continuousModeTime$d : _constants.DEFAULT_CONTINUOUS_MODE_DELAY;
      state.isContinuousModeEnabled = true;
    }

    // Description
    if (transformConfig.description !== undefined) {
      state.transformDescription = transformConfig.description;
    }

    // Ingest Pipeline
    if (transformConfig.dest.pipeline !== undefined) {
      state.destinationIngestPipeline = transformConfig.dest.pipeline;
    }

    // Frequency
    if (transformConfig.frequency !== undefined) {
      state.transformFrequency = transformConfig.frequency;
    }

    // Retention policy
    const retentionPolicyTime = (_transformConfig$rete = transformConfig.retention_policy) === null || _transformConfig$rete === void 0 ? void 0 : _transformConfig$rete.time;
    if (retentionPolicyTime !== undefined) {
      state.retentionPolicyDateField = retentionPolicyTime.field;
      state.retentionPolicyMaxAge = retentionPolicyTime.max_age;
      state.isRetentionPolicyEnabled = true;
    }

    // Settings
    if (transformConfig.settings) {
      var _transformConfig$sett, _transformConfig$sett2, _transformConfig$sett3;
      if (typeof ((_transformConfig$sett = transformConfig.settings) === null || _transformConfig$sett === void 0 ? void 0 : _transformConfig$sett.max_page_search_size) === 'number') {
        state.transformSettingsMaxPageSearchSize = transformConfig.settings.max_page_search_size;
      }
      if (typeof ((_transformConfig$sett2 = transformConfig.settings) === null || _transformConfig$sett2 === void 0 ? void 0 : _transformConfig$sett2.docs_per_second) === 'number') {
        state.transformSettingsDocsPerSecond = transformConfig.settings.docs_per_second;
      } else {
        state.transformSettingsDocsPerSecond = null;
      }
      if (typeof ((_transformConfig$sett3 = transformConfig.settings) === null || _transformConfig$sett3 === void 0 ? void 0 : _transformConfig$sett3.num_failure_retries) === 'number') {
        state.transformSettingsNumFailureRetries = transformConfig.settings.num_failure_retries;
      }
    }
    if (transformConfig._meta) {
      state._meta = transformConfig._meta;
    }
  }
  return state;
}