"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterRangeForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/transform/public/app/sections/create_transform/components/step_define/common/filter_agg/components/filter_range_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BUTTON_SIZE = 40;

// The config prop of the component, to be used for the `updateConfig` function.

/**
 * Form component for the range filter aggregation for number type fields.
 */
const FilterRangeForm = ({
  config,
  onChange
}) => {
  var _config$from, _config$to, _config$includeFrom, _config$includeTo;
  const from = (_config$from = config === null || config === void 0 ? void 0 : config.from) !== null && _config$from !== void 0 ? _config$from : '';
  const to = (_config$to = config === null || config === void 0 ? void 0 : config.to) !== null && _config$to !== void 0 ? _config$to : '';
  const includeFrom = (_config$includeFrom = config === null || config === void 0 ? void 0 : config.includeFrom) !== null && _config$includeFrom !== void 0 ? _config$includeFrom : false;
  const includeTo = (_config$includeTo = config === null || config === void 0 ? void 0 : config.includeTo) !== null && _config$includeTo !== void 0 ? _config$includeTo : false;
  const updateConfig = (0, _react.useCallback)(update => {
    onChange({
      config: {
        ...config,
        ...update
      }
    });
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [config]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.agg.popoverForm.filerAgg.range.greaterThanLabel",
      defaultMessage: "Greater than",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: from,
    max: to !== '' ? to : undefined,
    onChange: e => {
      updateConfig({
        from: e.target.value === '' ? undefined : Number(e.target.value)
      });
    },
    step: "any",
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      minWidth: BUTTON_SIZE,
      style: {
        maxWidth: BUTTON_SIZE
      },
      onChange: e => {
        updateConfig({
          includeFrom: e.target.checked
        });
      },
      fill: includeFrom,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 17
      }
    }, includeFrom ? '≥' : '>'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.agg.popoverForm.filerAgg.range.lessThanLabel",
      defaultMessage: "Less than",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: to,
    min: from !== '' ? from : undefined,
    onChange: e => {
      updateConfig({
        to: e.target.value === '' ? undefined : Number(e.target.value)
      });
    },
    step: "any",
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      minWidth: BUTTON_SIZE,
      style: {
        maxWidth: BUTTON_SIZE
      },
      onClick: () => {
        updateConfig({
          includeTo: !includeTo
        });
      },
      fill: includeTo,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 17
      }
    }, includeTo ? '≤' : '<'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  })))));
};
exports.FilterRangeForm = FilterRangeForm;