"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupByLabelForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("../../../../common");
var _styles = require("../../styles");
var _popover_form = require("./popover_form");
var _styles2 = require("./styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/transform/public/app/sections/create_transform/components/group_by_list/group_by_label_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GroupByLabelForm = ({
  deleteHandler,
  item,
  otherAggNames,
  onChange,
  options
}) => {
  const intervalButtonStyles = (0, _styles.useIntervalButtonStyles)();
  const [isPopoverVisible, setPopoverVisibility] = (0, _react.useState)(false);
  function update(updateItem) {
    onChange({
      ...updateItem
    });
    setPopoverVisibility(false);
  }
  let interval;
  if ((0, _common.isGroupByDateHistogram)(item)) {
    interval = item.calendar_interval;
  } else if ((0, _common.isGroupByHistogram)(item)) {
    interval = item.interval;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: _styles.transformLabelStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textTruncate",
    "data-test-subj": "transformGroupByEntryLabel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, item.aggName)), interval !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: _styles2.groupByStyles.interval,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    className: "eui-textTruncate",
    "data-test-subj": "transformGroupByEntryIntervalLabel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }, interval)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: intervalButtonStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "transformIntervalFormPopover",
    ownFocus: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.transform.groupByLabelForm.editIntervalAriaLabel', {
        defaultMessage: 'Edit interval'
      }),
      size: "s",
      iconType: "pencil",
      onClick: () => setPopoverVisibility(!isPopoverVisible),
      "data-test-subj": "transformGroupByEntryEditButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 13
      }
    }),
    isOpen: isPopoverVisible,
    closePopover: () => setPopoverVisibility(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_popover_form.PopoverForm, {
    defaultData: item,
    onChange: update,
    otherAggNames: otherAggNames,
    options: options,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: intervalButtonStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.transform.groupByLabelForm.deleteItemAriaLabel', {
      defaultMessage: 'Delete item'
    }),
    size: "s",
    iconType: "cross",
    onClick: () => deleteHandler(item.aggName),
    "data-test-subj": "transformGroupByEntryDeleteButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  })));
};
exports.GroupByLabelForm = GroupByLabelForm;