"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubAggsSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlFieldStatsFlyout = require("@kbn/ml-field-stats-flyout");
var _list_form = require("./list_form");
var _aggregation_dropdown = require("../aggregation_dropdown");
var _pivot_configuration = require("../pivot_configuration/pivot_configuration");
var _pivot_aggs = require("../../../../common/pivot_aggs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/transform/public/app/sections/create_transform/components/aggregation_list/sub_aggs_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Component for managing sub-aggregation of the provided
 * aggregation item.
 */
const SubAggsSection = ({
  item
}) => {
  const {
    state,
    actions
  } = (0, _react.useContext)(_pivot_configuration.PivotConfigurationContext);
  const addSubAggHandler = (0, _react.useCallback)(d => {
    actions.addSubAggregation(item, d);
  }, [actions, item]);
  const updateSubAggHandler = (0, _react.useCallback)((prevSubItemName, subItem) => {
    actions.updateSubAggregation(prevSubItemName, subItem);
  }, [actions]);
  const deleteSubAggHandler = (0, _react.useCallback)(subAggName => {
    actions.deleteSubAggregation(item, subAggName);
  }, [actions, item]);
  const isNewSubAggAllowed = (0, _react.useMemo)(() => {
    let nestingLevel = 1;
    let parentItem = item.parentAgg;
    while (parentItem !== undefined) {
      nestingLevel++;
      parentItem = parentItem.parentAgg;
    }
    return nestingLevel <= _pivot_aggs.MAX_NESTING_SUB_AGGS;
  }, [item]);
  const {
    handleFieldStatsButtonClick,
    populatedFields
  } = (0, _mlFieldStatsFlyout.useFieldStatsTrigger)();
  const options = (0, _react.useMemo)(() => {
    const opts = [];
    state.aggOptions.forEach(({
      label,
      field,
      options: aggOptions
    }) => {
      const isEmpty = populatedFields && field.id ? !populatedFields.has(field.id) : false;
      const aggOption = {
        isGroupLabel: true,
        key: field.id,
        searchableLabel: label,
        // @ts-ignore Purposefully passing label as element instead of string
        // for more robust rendering
        label: /*#__PURE__*/_react.default.createElement(_mlFieldStatsFlyout.FieldStatsInfoButton, {
          isEmpty: populatedFields && !populatedFields.has(field.id),
          field: field,
          label: label,
          onButtonClick: handleFieldStatsButtonClick,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 74,
            columnNumber: 11
          }
        })
      };
      if (aggOptions.length) {
        opts.push(aggOption);
        opts.push(...aggOptions.map(o => ({
          ...o,
          isEmpty,
          isGroupLabel: false,
          searchableLabel: o.label
        })));
      }
    });
    return opts;
  }, [handleFieldStatsButtonClick, populatedFields, state.aggOptions]);
  const dropdown = /*#__PURE__*/_react.default.createElement(_aggregation_dropdown.DropDown, {
    changeHandler: addSubAggHandler,
    options: options,
    placeholder: _i18n.i18n.translate('xpack.transform.stepDefineForm.addSubAggregationPlaceholder', {
      defaultMessage: 'Add a sub-aggregation ...'
    }),
    testSubj: "transformSubAggregationSelection",
    isDisabled: !isNewSubAggAllowed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }), item.subAggs && /*#__PURE__*/_react.default.createElement(_list_form.AggListForm, {
    onChange: updateSubAggHandler,
    deleteHandler: deleteSubAggHandler,
    list: item.subAggs,
    options: state.aggOptionsData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }), isNewSubAggAllowed ? dropdown : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorClassName: "eui-displayBlock",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.stepDefineForm.maxSubAggsLevelsLimitMessage",
      defaultMessage: "You have reached the maximum number of levels of sub-aggregations that can be added in the form. Please edit the JSON config if you want to add another level.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }, dropdown));
};
exports.SubAggsSection = SubAggsSection;