"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PopoverForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _useUpdateEffect = _interopRequireDefault(require("react-use/lib/useUpdateEffect"));
var _common = require("../../../../../../common/types/common");
var _common2 = require("../../../../common");
var _pivot_aggs = require("../../../../common/pivot_aggs");
var _get_agg_form_config = require("../step_define/common/get_agg_form_config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/transform/public/app/sections/create_transform/components/aggregation_list/popover_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PopoverForm = ({
  defaultData,
  otherAggNames,
  onChange,
  options
}) => {
  var _aggConfigDef$getErro;
  const [aggConfigDef, setAggConfigDef] = (0, _react.useState)((0, _lodash.cloneDeep)(defaultData));
  const [aggName, setAggName] = (0, _react.useState)(defaultData.aggName);
  const [agg, setAgg] = (0, _react.useState)(defaultData.agg);
  const [field, setField] = (0, _react.useState)((0, _common2.isPivotAggsConfigWithUiBase)(defaultData) ? defaultData.field : '');
  const isUnsupportedAgg = !(0, _common2.isPivotAggsConfigWithUiBase)(defaultData);

  // Update configuration based on the aggregation type
  (0, _react.useEffect)(() => {
    if (agg === aggConfigDef.agg) return;
    const config = (0, _get_agg_form_config.getAggFormConfig)(agg, {
      parentAgg: aggConfigDef.parentAgg,
      subAggs: aggConfigDef.subAggs,
      agg,
      aggName,
      dropDownName: aggName,
      field
    });
    setAggConfigDef(config);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [agg, aggConfigDef]);
  (0, _useUpdateEffect.default)(() => {
    if ((0, _pivot_aggs.isPivotAggsWithExtendedForm)(aggConfigDef)) {
      const name = aggConfigDef.getAggName ? aggConfigDef.getAggName() : undefined;
      if (name !== undefined) {
        setAggName(name);
      }
    }
  }, [aggConfigDef]);
  const availableFields = [];
  const availableAggs = [];
  function updateAgg(aggVal) {
    setAgg(aggVal);
  }
  function getUpdatedItem() {
    let resultField = field;
    if ((0, _common2.isPivotAggsConfigWithUiBase)(aggConfigDef) && !aggConfigDef.isMultiField && Array.isArray(field)) {
      // reset to a single field in case agg doesn't support multiple fields
      resultField = field[0];
    }
    const updatedItem = {
      ...aggConfigDef,
      agg,
      aggName,
      dropDownName: defaultData.dropDownName,
      ...(isUnsupportedAgg ? {} : {
        field: resultField
      })
    };
    return updatedItem;
  }
  if (!isUnsupportedAgg) {
    const optionsArr = (0, _common.dictionaryToArray)(options);
    optionsArr.filter(o => o.agg === defaultData.agg).forEach(o => {
      availableFields.push({
        text: o.field
      });
    });
    optionsArr.filter(o => (0, _common2.isPivotAggsConfigWithUiBase)(defaultData) && (Array.isArray(defaultData.field) ? defaultData.field.includes(o.field) : o.field === defaultData.field)).forEach(o => {
      availableAggs.push({
        text: o.agg
      });
    });
  }
  let aggNameError = '';
  let validAggName = (0, _common2.isAggName)(aggName);
  if (!validAggName) {
    aggNameError = _i18n.i18n.translate('xpack.transform.agg.popoverForm.aggNameInvalidCharError', {
      defaultMessage: 'Invalid name. The characters "[", "]", and ">" are not allowed and the name must not start or end with a space character.'
    });
  }
  if (validAggName) {
    validAggName = !otherAggNames.includes(aggName);
    aggNameError = _i18n.i18n.translate('xpack.transform.agg.popoverForm.aggNameAlreadyUsedError', {
      defaultMessage: 'Another aggregation already uses that name.'
    });
  }
  let formValid = validAggName;
  if ((0, _pivot_aggs.isPivotAggsWithExtendedForm)(aggConfigDef)) {
    formValid = validAggName && aggConfigDef.isValid();
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    css: {
      width: '300px'
    },
    "data-test-subj": 'transformAggPopoverForm_' + aggName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: !validAggName && [aggNameError],
    isInvalid: !validAggName,
    helpText: isUnsupportedAgg ? _i18n.i18n.translate('xpack.transform.agg.popoverForm.unsupportedAggregationHelpText', {
      defaultMessage: 'Only the aggregation name can be edited in this form. Please use the advanced editor to edit the other parts of the aggregation.'
    }) : '',
    label: _i18n.i18n.translate('xpack.transform.agg.popoverForm.nameLabel', {
      defaultMessage: 'Aggregation name'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: aggName,
    isInvalid: !validAggName,
    onChange: e => setAggName(e.target.value),
    "data-test-subj": "transformAggName",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 9
    }
  })), availableFields.length > 0 ? aggConfigDef.isMultiField ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.agg.popoverForm.fieldsLabel', {
      defaultMessage: 'Fields'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    options: availableFields.map(v => {
      return {
        value: v.text,
        label: v.text
      };
    }),
    selectedOptions: !!field ? (typeof field === 'string' ? [field] : field).map(v => ({
      value: v,
      label: v
    })) : [],
    onChange: e => {
      const res = e.map(v => v.value);
      setField(res);
    },
    isClearable: false,
    "data-test-subj": "transformAggFields",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 13
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.agg.popoverForm.fieldLabel', {
      defaultMessage: 'Field'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: availableFields,
    value: field,
    onChange: e => setField(e.target.value),
    "data-test-subj": "transformAggField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 13
    }
  })) : null, availableAggs.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.agg.popoverForm.aggLabel', {
      defaultMessage: 'Aggregation'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: availableAggs,
    value: agg,
    onChange: e => updateAgg(e.target.value),
    "data-test-subj": "transformAggType",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 11
    }
  })), (0, _pivot_aggs.isPivotAggsWithExtendedForm)(aggConfigDef) ? /*#__PURE__*/_react.default.createElement(aggConfigDef.AggFormComponent, {
    aggConfig: aggConfigDef.aggConfig,
    selectedField: field,
    onChange: update => {
      setAggConfigDef({
        ...aggConfigDef,
        aggConfig: update
      });
    },
    isValid: aggConfigDef.isValid(),
    errorMessages: (_aggConfigDef$getErro = aggConfigDef.getErrorMessages) === null || _aggConfigDef$getErro === void 0 ? void 0 : _aggConfigDef$getErro.call(aggConfigDef),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 9
    }
  }) : null, isUnsupportedAgg && /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    "aria-label": _i18n.i18n.translate('xpack.transform.agg.popoverForm.codeBlock', {
      defaultMessage: 'JSON of transform aggregation'
    }),
    fontSize: "s",
    language: "json",
    paddingSize: "s",
    css: {
      width: '100%',
      height: '200px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 9
    }
  }, JSON.stringify((0, _common2.getEsAggFromAggConfig)(defaultData), null, 2)), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isDisabled: !formValid,
    onClick: () => onChange(getUpdatedItem()),
    "data-test-subj": "transformApplyAggChanges",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.transform.agg.popoverForm.submitButtonLabel', {
    defaultMessage: 'Apply'
  }))));
};
exports.PopoverForm = PopoverForm;