"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedPivotEditorSwitch = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _switch_modal = require("../switch_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/transform/public/app/sections/create_transform/components/advanced_pivot_editor_switch/advanced_pivot_editor_switch.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AdvancedPivotEditorSwitch = ({
  advancedPivotEditor: {
    actions: {
      setAdvancedEditorSwitchModalVisible,
      toggleAdvancedEditor
    },
    state: {
      advancedEditorConfig,
      advancedEditorConfigLastApplied,
      isAdvancedEditorSwitchModalVisible,
      isAdvancedPivotEditorEnabled,
      isAdvancedPivotEditorApplyButtonEnabled
    }
  }
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedEditorSwitchLabel', {
      defaultMessage: 'Edit JSON config'
    }),
    checked: isAdvancedPivotEditorEnabled,
    onChange: () => {
      if (isAdvancedPivotEditorEnabled && (isAdvancedPivotEditorApplyButtonEnabled || advancedEditorConfig !== advancedEditorConfigLastApplied)) {
        setAdvancedEditorSwitchModalVisible(true);
        return;
      }
      toggleAdvancedEditor();
    },
    "data-test-subj": "transformAdvancedPivotEditorSwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 11
    }
  }), isAdvancedEditorSwitchModalVisible && /*#__PURE__*/_react.default.createElement(_switch_modal.SwitchModal, {
    onCancel: () => setAdvancedEditorSwitchModalVisible(false),
    onConfirm: () => {
      setAdvancedEditorSwitchModalVisible(false);
      toggleAdvancedEditor();
    },
    type: 'pivot',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 13
    }
  }))));
};
exports.AdvancedPivotEditorSwitch = AdvancedPivotEditorSwitch;