"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _tests_selection_control = require("./tests_selection_control");
var _transform_selector_control = require("./transform_selector_control");
var _hooks = require("../../app/hooks");
var _app_dependencies = require("../../app/app_dependencies");
var _constants = require("../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/transform/public/alerting/transform_health_rule_type/transform_health_rule_trigger.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TransformHealthRuleTrigger = ({
  ruleParams,
  setRuleParams,
  errors
}) => {
  var _ruleParams$includeTr2, _ruleParams$excludeTr, _ruleParams$excludeTr2;
  const formErrors = Object.values(errors).flat();
  const isFormInvalid = formErrors.length > 0;
  const toast = (0, _app_dependencies.useToastNotifications)();
  const {
    error,
    data
  } = (0, _hooks.useGetTransforms)();
  const transformOptions = (0, _react.useMemo)(() => {
    var _data$transforms$filt;
    return (_data$transforms$filt = data === null || data === void 0 ? void 0 : data.transforms.filter(v => v.config.sync).map(v => v.id)) !== null && _data$transforms$filt !== void 0 ? _data$transforms$filt : [];
  }, [data]);
  const onAlertParamChange = (0, _react.useCallback)(param => update => {
    setRuleParams(param, update);
  }, [setRuleParams]);
  (0, _react.useEffect)(() => {
    if (error !== null) {
      toast.addError(error, {
        title: _i18n.i18n.translate('xpack.transform.alertingRuleTypes.transformHealth.fetchErrorMessage', {
          defaultMessage: 'Unable to fetch transforms'
        })
      });
    }
  }, [error, toast]);
  const excludeTransformOptions = (0, _react.useMemo)(() => {
    var _ruleParams$includeTr;
    if ((_ruleParams$includeTr = ruleParams.includeTransforms) !== null && _ruleParams$includeTr !== void 0 && _ruleParams$includeTr.some(v => v === _constants.ALL_TRANSFORMS_SELECTION)) {
      return transformOptions;
    }
    return null;
  }, [transformOptions, ruleParams.includeTransforms]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": 'transformHealthAlertingRuleForm',
    invalidCallout: 'none',
    error: formErrors,
    isInvalid: isFormInvalid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_transform_selector_control.TransformSelectorControl, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.alertTypes.transformHealth.includeTransformsLabel",
      defaultMessage: "Include transforms",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 11
      }
    }),
    options: transformOptions,
    selectedOptions: (_ruleParams$includeTr2 = ruleParams.includeTransforms) !== null && _ruleParams$includeTr2 !== void 0 ? _ruleParams$includeTr2 : [],
    onChange: onAlertParamChange('includeTransforms'),
    allowSelectAll: true,
    errors: errors.includeTransforms,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }), !!(excludeTransformOptions !== null && excludeTransformOptions !== void 0 && excludeTransformOptions.length) || !!((_ruleParams$excludeTr = ruleParams.excludeTransforms) !== null && _ruleParams$excludeTr !== void 0 && _ruleParams$excludeTr.length) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_transform_selector_control.TransformSelectorControl, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.alertTypes.transformHealth.excludeTransformsLabel",
      defaultMessage: "Exclude transforms",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 15
      }
    }),
    options: excludeTransformOptions !== null && excludeTransformOptions !== void 0 ? excludeTransformOptions : [],
    selectedOptions: (_ruleParams$excludeTr2 = ruleParams.excludeTransforms) !== null && _ruleParams$excludeTr2 !== void 0 ? _ruleParams$excludeTr2 : [],
    onChange: onAlertParamChange('excludeTransforms'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_tests_selection_control.TestsSelectionControl, {
    config: ruleParams.testsConfig,
    onChange: onAlertParamChange('testsConfig'),
    errors: Array.isArray(errors.testsConfig) ? errors.testsConfig : [],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }));
};

// Default export is required for React.lazy loading

// eslint-disable-next-line import/no-default-export
var _default = exports.default = TransformHealthRuleTrigger;
module.exports = exports.default;