"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertRuleManageContext = exports.TransformAlertFlyoutWrapper = exports.TransformAlertFlyout = exports.AlertRulesManageContext = void 0;
exports.useAlertRuleFlyout = useAlertRuleFlyout;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _flyout = require("@kbn/response-ops-rule-form/flyout");
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _app_dependencies = require("../app/app_dependencies");
var _common = require("../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/transform/public/alerting/transform_alerting_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TransformAlertFlyout = ({
  initialAlert,
  ruleParams,
  onCloseFlyout,
  onSave
}) => {
  const {
    triggersActionsUi,
    ...plugins
  } = (0, _app_dependencies.useAppDependencies)();
  const AlertFlyout = (0, _react.useMemo)(() => {
    if (!triggersActionsUi) return;
    const {
      ruleTypeRegistry,
      actionTypeRegistry
    } = triggersActionsUi;
    const commonProps = {
      plugins: {
        ...plugins,
        ruleTypeRegistry,
        actionTypeRegistry
      },
      onCancel: () => {
        onCloseFlyout();
      },
      onSubmit: async () => {
        if (onSave) {
          onSave();
        }
        onCloseFlyout();
      }
    };
    if (initialAlert) {
      return /*#__PURE__*/_react.default.createElement(_flyout.RuleFormFlyout, (0, _extends2.default)({}, commonProps, {
        id: initialAlert.id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 14
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_flyout.RuleFormFlyout, (0, _extends2.default)({}, commonProps, {
      consumer: 'stackAlerts',
      ruleTypeId: _common.TRANSFORM_RULE_TYPE.TRANSFORM_HEALTH,
      initialMetadata: {},
      initialValues: {
        params: ruleParams
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 7
      }
    }));
    // deps on id to avoid re-rendering on auto-refresh
  }, [triggersActionsUi, plugins, initialAlert, ruleParams, onCloseFlyout, onSave]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, AlertFlyout);
};
exports.TransformAlertFlyout = TransformAlertFlyout;
const getAlertRuleManageContext = exports.getAlertRuleManageContext = (0, _lodash.memoize)(function () {
  const ruleState$ = new _rxjs.BehaviorSubject({
    editAlertRule: null,
    createAlertRule: null
  });
  return {
    editAlertRule$: ruleState$.pipe((0, _rxjs.pluck)('editAlertRule')),
    createAlertRule$: ruleState$.pipe((0, _rxjs.pluck)('createAlertRule')),
    setEditAlertRule: initialRule => {
      ruleState$.next({
        createAlertRule: null,
        editAlertRule: initialRule
      });
    },
    setCreateAlertRule: transformId => {
      ruleState$.next({
        createAlertRule: {
          includeTransforms: [transformId]
        },
        editAlertRule: null
      });
    },
    hideAlertFlyout: () => {
      ruleState$.next({
        createAlertRule: null,
        editAlertRule: null
      });
    }
  };
});
const AlertRulesManageContext = exports.AlertRulesManageContext = /*#__PURE__*/(0, _react.createContext)(getAlertRuleManageContext());
function useAlertRuleFlyout() {
  return (0, _react.useContext)(AlertRulesManageContext);
}
const TransformAlertFlyoutWrapper = () => {
  const {
    editAlertRule$,
    createAlertRule$,
    hideAlertFlyout
  } = useAlertRuleFlyout();
  const editAlertRule = (0, _useObservable.default)(editAlertRule$);
  const createAlertRule = (0, _useObservable.default)(createAlertRule$);
  return editAlertRule || createAlertRule ? /*#__PURE__*/_react.default.createElement(TransformAlertFlyout, {
    initialAlert: editAlertRule,
    ruleParams: createAlertRule,
    onCloseFlyout: hideAlertFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 5
    }
  }) : null;
};
exports.TransformAlertFlyoutWrapper = TransformAlertFlyoutWrapper;