"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getResultTestConfig = getResultTestConfig;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getResultTestConfig(config) {
  var _config$healthCheck, _config$errorMessages, _config$notStarted$en, _config$notStarted, _config$errorMessages2, _config$errorMessages3;
  let healthCheckEnabled = true;
  if (typeof (config === null || config === void 0 ? void 0 : (_config$healthCheck = config.healthCheck) === null || _config$healthCheck === void 0 ? void 0 : _config$healthCheck.enabled) === 'boolean') {
    var _config$healthCheck2;
    healthCheckEnabled = config === null || config === void 0 ? void 0 : (_config$healthCheck2 = config.healthCheck) === null || _config$healthCheck2 === void 0 ? void 0 : _config$healthCheck2.enabled;
  } else if (typeof (config === null || config === void 0 ? void 0 : (_config$errorMessages = config.errorMessages) === null || _config$errorMessages === void 0 ? void 0 : _config$errorMessages.enabled) === 'boolean') {
    // if errorMessages test has been explicitly enabled / disabled,
    // also disabled the healthCheck test
    healthCheckEnabled = false;
  }
  return {
    notStarted: {
      enabled: (_config$notStarted$en = config === null || config === void 0 ? void 0 : (_config$notStarted = config.notStarted) === null || _config$notStarted === void 0 ? void 0 : _config$notStarted.enabled) !== null && _config$notStarted$en !== void 0 ? _config$notStarted$en : true
    },
    /**
     * @deprecated replaced in favor of healthCheck in 8.8
     */
    errorMessages: {
      enabled: (_config$errorMessages2 = config === null || config === void 0 ? void 0 : (_config$errorMessages3 = config.errorMessages) === null || _config$errorMessages3 === void 0 ? void 0 : _config$errorMessages3.enabled) !== null && _config$errorMessages2 !== void 0 ? _config$errorMessages2 : false
    },
    healthCheck: {
      enabled: healthCheckEnabled
    }
  };
}