"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tracingConfigSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _inferenceTracingConfig = require("@kbn/inference-tracing-config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * The tracing config schema that is exposed by the Telemetry plugin.
 */
const tracingConfigSchema = exports.tracingConfigSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: false
  }),
  sample_rate: _configSchema.schema.number({
    defaultValue: 1,
    min: 0,
    max: 1
  }),
  exporters: _configSchema.schema.oneOf([_inferenceTracingConfig.inferenceTracingExportConfigSchema, _configSchema.schema.arrayOf(_inferenceTracingConfig.inferenceTracingExportConfigSchema)], {
    defaultValue: []
  })
});