"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FILTER_OUT_VALUE_KEYBOARD_SHORTCUT = exports.FILTER_OUT_VALUE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _accessibility = require("../../../../common/utils/accessibility");
var _tooltip_with_keyboard_shortcut = require("../../tooltip_with_keyboard_shortcut");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/timelines/public/components/hover_actions/actions/filter_out_value.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FILTER_OUT_VALUE = exports.FILTER_OUT_VALUE = _i18n.i18n.translate('xpack.timelines.hoverActions.filterOut', {
  defaultMessage: 'Filter out'
});
const FILTER_OUT_VALUE_KEYBOARD_SHORTCUT = exports.FILTER_OUT_VALUE_KEYBOARD_SHORTCUT = 'o';
const FilterOutValueButton = exports.default = /*#__PURE__*/_react.default.memo(({
  Component,
  defaultFocusedButtonRef,
  field,
  filterManager,
  keyboardEvent,
  onFilterAdded,
  ownFocus,
  onClick,
  size,
  showTooltip = false,
  value,
  dataViewId
}) => {
  const filterOutValueFn = (0, _react.useCallback)(() => {
    const makeFilter = currentVal => currentVal == null || (currentVal === null || currentVal === void 0 ? void 0 : currentVal.length) === 0 ? (0, _utils.createFilter)(field, null, false, dataViewId) : (0, _utils.createFilter)(field, currentVal, true, dataViewId);
    const filters = Array.isArray(value) ? value.map(currentVal => makeFilter(currentVal)) : makeFilter(value);
    const activeFilterManager = filterManager;
    if (activeFilterManager != null) {
      activeFilterManager.addFilters(filters);
      if (onFilterAdded != null) {
        onFilterAdded();
      }
    }
    if (onClick != null) {
      onClick();
    }
  }, [field, filterManager, onClick, onFilterAdded, value, dataViewId]);
  (0, _react.useEffect)(() => {
    if (!ownFocus) {
      return;
    }
    if ((keyboardEvent === null || keyboardEvent === void 0 ? void 0 : keyboardEvent.key) === FILTER_OUT_VALUE_KEYBOARD_SHORTCUT) {
      (0, _accessibility.stopPropagationAndPreventDefault)(keyboardEvent);
      filterOutValueFn();
    }
  }, [filterOutValueFn, keyboardEvent, ownFocus]);
  const button = (0, _react.useMemo)(() => Component ? /*#__PURE__*/_react.default.createElement(Component, {
    "aria-label": FILTER_OUT_VALUE,
    buttonRef: defaultFocusedButtonRef,
    "data-test-subj": "filter-out-value",
    iconType: "minusInCircle",
    onClick: filterOutValueFn,
    size: size,
    title: FILTER_OUT_VALUE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, FILTER_OUT_VALUE) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": FILTER_OUT_VALUE,
    buttonRef: defaultFocusedButtonRef,
    className: "timelines__hoverActionButton",
    "data-test-subj": "filter-out-value",
    iconSize: "s",
    iconType: "minusInCircle",
    onClick: filterOutValueFn,
    size: size,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }), [Component, defaultFocusedButtonRef, filterOutValueFn, size]);
  return showTooltip ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_tooltip_with_keyboard_shortcut.TooltipWithKeyboardShortcut, {
      additionalScreenReaderOnlyContext: (0, _utils.getAdditionalScreenReaderOnlyContext)({
        field,
        value
      }),
      content: FILTER_OUT_VALUE,
      shortcut: FILTER_OUT_VALUE_KEYBOARD_SHORTCUT,
      showShortcut: ownFocus,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, button) : button;
});
FilterOutValueButton.displayName = 'FilterOutValueButton';

// eslint-disable-next-line import/no-default-export