"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LocalEBTShipper = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _local_shipper = require("../../common/local_shipper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class LocalEBTShipper {
  constructor(config, initContext) {
    (0, _defineProperty2.default)(this, "reportEvents", events => {
      this.config.getElasticsearchClient().then(esClient => esClient.bulk({
        index: _local_shipper.TELEMETRY_LOCAL_EBT_INDICES.SERVER,
        operations: events.flatMap(doc => [{
          create: {}
        }, doc])
      })).catch(err => {
        this.initContext.logger.error(err);
      });
    });
    (0, _defineProperty2.default)(this, "optIn", () => {
      // This shipper doesn't need to update anything internal on optIn changes
    });
    (0, _defineProperty2.default)(this, "flush", async () => {
      // This shipper doesn't hold any queues. Nothing to flush in this method.
    });
    (0, _defineProperty2.default)(this, "shutdown", () => {
      // This shipper doesn't hold any internal queues or instantiated properties. No need to clean up anything in this method.
    });
    this.config = config;
    this.initContext = initContext;
  }
}
exports.LocalEBTShipper = LocalEBTShipper;
(0, _defineProperty2.default)(LocalEBTShipper, "shipperName", 'local_ebt_shipper_server');