"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeLocalShipper = initializeLocalShipper;
var _rxjs = require("rxjs");
var _configSchema = require("@kbn/config-schema");
var _local_shipper = require("../../common/local_shipper");
var _local_ebt_shipper = require("./local_ebt_shipper");
var _register_mappings = require("./register_mappings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const esClient$ = new _rxjs.Subject();
function initializeLocalShipper(logger, {
  analytics,
  http
}) {
  const getElasticsearchClient = () => (0, _rxjs.firstValueFrom)(esClient$);
  const elasticsearchClientWithDelay = getElasticsearchClient().then(async esClient => {
    // Wait 5s after the ES client has been resolved to give time for the indices to be created
    await new Promise(resolve => setTimeout(resolve, 5000));
    return esClient;
  });
  const getElasticsearchClientWithDelay = () => elasticsearchClientWithDelay;

  // Using void because it won't reject
  void (0, _register_mappings.registerIndexMappings)(getElasticsearchClient, logger.get('index-setup'));
  analytics.registerShipper(_local_ebt_shipper.LocalEBTShipper, {
    getElasticsearchClient: getElasticsearchClientWithDelay
  });
  registerRoute(http, getElasticsearchClientWithDelay);
}
function registerRoute(http, getElasticsearchClient) {
  http.createRouter().versioned.post({
    path: '/internal/telemetry/ebt_local_shipper',
    access: 'internal',
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to the Elasticsearch client'
      }
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: _configSchema.schema.object({
          events: _configSchema.schema.arrayOf(_configSchema.schema.any())
        })
      }
    }
  }, async (context, request, response) => {
    esClient$.next((await context.core).elasticsearch.client.asCurrentUser); // Hack to obtain an ES client with permissions to write to data indices

    const esClient = await getElasticsearchClient();
    try {
      await esClient.bulk({
        index: _local_shipper.TELEMETRY_LOCAL_EBT_INDICES.BROWSER,
        operations: request.body.events.flatMap(doc => [{
          create: {}
        }, doc])
      });
      return response.ok();
    } catch (error) {
      return response.customError({
        statusCode: 500,
        body: error
      });
    }
  });
}