"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryManagementSectionPlugin = void 0;
var _react = _interopRequireDefault(require("react"));
var _telemetry_management_section_wrapper = require("./components/telemetry_management_section_wrapper");
var _common = require("../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/telemetry_management_section/public/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
class TelemetryManagementSectionPlugin {
  setup(core, {
    advancedSettings,
    telemetry: {
      telemetryService
    },
    usageCollection
  }) {
    var _usageCollection$comp;
    let docLinksLinks;
    core.getStartServices().then(([{
      docLinks
    }]) => {
      docLinksLinks = docLinks === null || docLinks === void 0 ? void 0 : docLinks.links;
    });
    const ApplicationUsageTrackingProvider = (_usageCollection$comp = usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.components.ApplicationUsageTrackingProvider) !== null && _usageCollection$comp !== void 0 ? _usageCollection$comp : _react.default.Fragment;
    const queryMatch = query => {
      const searchTerm = query.toLowerCase();
      return telemetryService.getCanChangeOptInStatus() && _common.SEARCH_TERMS.some(term => term.indexOf(searchTerm) >= 0);
    };
    advancedSettings.addGlobalSection(props => {
      return /*#__PURE__*/_react.default.createElement(ApplicationUsageTrackingProvider, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 9
        }
      }, (0, _telemetry_management_section_wrapper.telemetryManagementSectionWrapper)(telemetryService, docLinksLinks)(props));
    }, queryMatch);
    return {};
  }
  start(core) {}
}
exports.TelemetryManagementSectionPlugin = TelemetryManagementSectionPlugin;