"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTaskManagerUsageCollector = createTaskManagerUsageCollector;
exports.registerTaskManagerUsageCollector = registerTaskManagerUsageCollector;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createTaskManagerUsageCollector(usageCollection, monitoringStats$, monitoredUtilization$, excludeTaskTypes) {
  let lastMonitoredHealth = null;
  let lastMonitoredUtilizationStats = null;
  (0, _rxjs.combineLatest)([monitoringStats$, monitoredUtilization$]).pipe().subscribe(([health, utilization]) => {
    var _ref;
    lastMonitoredHealth = health;
    lastMonitoredUtilizationStats = (_ref = utilization === null || utilization === void 0 ? void 0 : utilization.stats) !== null && _ref !== void 0 ? _ref : null;
  });
  return usageCollection.makeUsageCollector({
    type: 'task_manager',
    isReady: async () => {
      return Boolean(lastMonitoredHealth);
    },
    fetch: async () => {
      var _lastMonitoredHealth, _lastMonitoredHealth$, _lastMonitoredUtiliza, _lastMonitoredUtiliza2, _lastMonitoredUtiliza3, _lastMonitoredUtiliza4, _lastMonitoredUtiliza5, _lastMonitoredUtiliza6, _lastMonitoredUtiliza7, _lastMonitoredUtiliza8, _lastMonitoredHealth$2, _lastMonitoredHealth2, _lastMonitoredHealth3;
      return {
        task_type_exclusion: excludeTaskTypes,
        failed_tasks: Object.entries((_lastMonitoredHealth = lastMonitoredHealth) === null || _lastMonitoredHealth === void 0 ? void 0 : (_lastMonitoredHealth$ = _lastMonitoredHealth.stats.workload) === null || _lastMonitoredHealth$ === void 0 ? void 0 : _lastMonitoredHealth$.value.task_types).reduce((numb, [key, val]) => {
          if (val.status.failed !== undefined) {
            numb += val.status.failed;
          }
          return numb;
        }, 0),
        recurring_tasks: {
          actual_service_time: (_lastMonitoredUtiliza = (_lastMonitoredUtiliza2 = lastMonitoredUtilizationStats) === null || _lastMonitoredUtiliza2 === void 0 ? void 0 : _lastMonitoredUtiliza2.value.recurring.ran.service_time.actual) !== null && _lastMonitoredUtiliza !== void 0 ? _lastMonitoredUtiliza : 0,
          adjusted_service_time: (_lastMonitoredUtiliza3 = (_lastMonitoredUtiliza4 = lastMonitoredUtilizationStats) === null || _lastMonitoredUtiliza4 === void 0 ? void 0 : _lastMonitoredUtiliza4.value.recurring.ran.service_time.adjusted) !== null && _lastMonitoredUtiliza3 !== void 0 ? _lastMonitoredUtiliza3 : 0
        },
        adhoc_tasks: {
          actual_service_time: (_lastMonitoredUtiliza5 = (_lastMonitoredUtiliza6 = lastMonitoredUtilizationStats) === null || _lastMonitoredUtiliza6 === void 0 ? void 0 : _lastMonitoredUtiliza6.value.adhoc.ran.service_time.actual) !== null && _lastMonitoredUtiliza5 !== void 0 ? _lastMonitoredUtiliza5 : 0,
          adjusted_service_time: (_lastMonitoredUtiliza7 = (_lastMonitoredUtiliza8 = lastMonitoredUtilizationStats) === null || _lastMonitoredUtiliza8 === void 0 ? void 0 : _lastMonitoredUtiliza8.value.adhoc.ran.service_time.adjusted) !== null && _lastMonitoredUtiliza7 !== void 0 ? _lastMonitoredUtiliza7 : 0
        },
        capacity: (_lastMonitoredHealth$2 = (_lastMonitoredHealth2 = lastMonitoredHealth) === null || _lastMonitoredHealth2 === void 0 ? void 0 : (_lastMonitoredHealth3 = _lastMonitoredHealth2.stats.capacity_estimation) === null || _lastMonitoredHealth3 === void 0 ? void 0 : _lastMonitoredHealth3.value.observed.max_throughput_per_minute_per_kibana) !== null && _lastMonitoredHealth$2 !== void 0 ? _lastMonitoredHealth$2 : 0
      };
    },
    schema: {
      task_type_exclusion: {
        type: 'array',
        items: {
          type: 'keyword'
        }
      },
      failed_tasks: {
        type: 'long'
      },
      recurring_tasks: {
        actual_service_time: {
          type: 'long'
        },
        adjusted_service_time: {
          type: 'long'
        }
      },
      adhoc_tasks: {
        actual_service_time: {
          type: 'long'
        },
        adjusted_service_time: {
          type: 'long'
        }
      },
      capacity: {
        type: 'long'
      }
    }
  });
}
function registerTaskManagerUsageCollector(usageCollection, monitoringStats$, monitoredUtilization$, excludeTaskTypes) {
  const collector = createTaskManagerUsageCollector(usageCollection, monitoringStats$, monitoredUtilization$, excludeTaskTypes);
  usageCollection.registerCollector(collector);
}