"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEmptyClaimOwnershipResult = getEmptyClaimOwnershipResult;
exports.getExcludedTaskTypes = getExcludedTaskTypes;
exports.getTaskClaimer = getTaskClaimer;
exports.isTaskTypeExcluded = isTaskTypeExcluded;
var _minimatch = _interopRequireDefault(require("minimatch"));
var _strategy_update_by_query = require("./strategy_update_by_query");
var _strategy_mget = require("./strategy_mget");
var _config = require("../config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let WarnedOnInvalidClaimer = false;
function getTaskClaimer(logger, strategy) {
  switch (strategy) {
    case _config.CLAIM_STRATEGY_UPDATE_BY_QUERY:
      return _strategy_update_by_query.claimAvailableTasksUpdateByQuery;
    case _config.CLAIM_STRATEGY_MGET:
      return _strategy_mget.claimAvailableTasksMget;
  }
  if (!WarnedOnInvalidClaimer) {
    WarnedOnInvalidClaimer = true;
    logger.warn(`Unknown task claiming strategy "${strategy}", falling back to update_by_query`);
  }
  return _strategy_update_by_query.claimAvailableTasksUpdateByQuery;
}
function getEmptyClaimOwnershipResult() {
  return {
    stats: {
      tasksUpdated: 0,
      tasksConflicted: 0,
      tasksClaimed: 0,
      staleTasks: 0
    },
    docs: []
  };
}
function isTaskTypeExcluded(excludedTaskTypePatterns, taskType) {
  for (const excludedTypePattern of excludedTaskTypePatterns) {
    if ((0, _minimatch.default)(taskType, excludedTypePattern)) {
      return true;
    }
  }
  return false;
}
function getExcludedTaskTypes(definitions, excludedTaskTypePatterns) {
  return definitions.getAllTypes().filter(taskType => isTaskTypeExcluded(excludedTaskTypePatterns, taskType));
}