"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TASK_SO_NAME = exports.BACKGROUND_TASK_NODE_SO_NAME = void 0;
Object.defineProperty(exports, "scheduleRruleSchemaV1", {
  enumerable: true,
  get: function () {
    return _rrule.scheduleRruleSchemaV1;
  }
});
Object.defineProperty(exports, "scheduleRruleSchemaV2", {
  enumerable: true,
  get: function () {
    return _rrule.scheduleRruleSchemaV2;
  }
});
Object.defineProperty(exports, "scheduleRruleSchemaV3", {
  enumerable: true,
  get: function () {
    return _rrule.scheduleRruleSchemaV3;
  }
});
exports.setupSavedObjects = setupSavedObjects;
var _mappings = require("./mappings");
var _migrations = require("./migrations");
var _oldest_idle_action_task = require("../queries/oldest_idle_action_task");
var _constants = require("../constants");
var _model_versions = require("./model_versions");
var _rrule = require("./schemas/rrule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TASK_SO_NAME = exports.TASK_SO_NAME = 'task';
const BACKGROUND_TASK_NODE_SO_NAME = exports.BACKGROUND_TASK_NODE_SO_NAME = 'background-task-node';
function setupSavedObjects(savedObjects, config) {
  savedObjects.registerType({
    name: TASK_SO_NAME,
    namespaceType: 'agnostic',
    hidden: true,
    convertToAliasScript: `ctx._id = ctx._source.type + ':' + ctx._id; ctx._source.remove("kibana")`,
    mappings: _mappings.taskMappings,
    migrations: (0, _migrations.getMigrations)(),
    indexPattern: _constants.TASK_MANAGER_INDEX,
    excludeOnUpgrade: async ({
      readonlyEsClient
    }) => {
      const oldestNeededActionParams = await (0, _oldest_idle_action_task.getOldestIdleActionTask)(readonlyEsClient, _constants.TASK_MANAGER_INDEX);

      // Delete all action tasks that have failed and are no longer needed
      return {
        bool: {
          must: [{
            terms: {
              'task.taskType': ['actions:.email', 'actions:.index', 'actions:.pagerduty', 'actions:.swimlane', 'actions:.server-log', 'actions:.slack', 'actions:.webhook', 'actions:.servicenow', 'actions:.servicenow-sir', 'actions:.jira', 'actions:.resilient', 'actions:.teams', 'actions:.sentinelone']
            }
          }, {
            term: {
              type: 'task'
            }
          }, {
            term: {
              'task.status': 'failed'
            }
          }, {
            range: {
              'task.runAt': {
                // Only apply to tasks that were run before the oldest needed action
                lt: oldestNeededActionParams
              }
            }
          }]
        }
      };
    },
    modelVersions: _model_versions.taskModelVersions
  });
  savedObjects.registerType({
    name: BACKGROUND_TASK_NODE_SO_NAME,
    namespaceType: 'agnostic',
    hidden: true,
    mappings: _mappings.backgroundTaskNodeMapping,
    indexPattern: _constants.TASK_MANAGER_INDEX,
    modelVersions: _model_versions.backgroundTaskNodeModelVersions
  });
}