"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteSyntheticsParamsBulkRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _sync_private_locations_monitors_task = require("../../../tasks/sync_private_locations_monitors_task");
var _saved_objects = require("../../../../common/types/saved_objects");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteSyntheticsParamsBulkRoute = () => ({
  method: 'POST',
  path: _constants.SYNTHETICS_API_URLS.PARAMS + '/_bulk_delete',
  validate: {},
  validation: {
    request: {
      body: _configSchema.schema.object({
        ids: _configSchema.schema.arrayOf(_configSchema.schema.string())
      })
    }
  },
  handler: async ({
    savedObjectsClient,
    request,
    server,
    spaceId
  }) => {
    const {
      ids
    } = request.body;
    const result = await savedObjectsClient.bulkDelete(ids.map(id => ({
      type: _saved_objects.syntheticsParamType,
      id
    })), {
      force: true
    });
    await (0, _sync_private_locations_monitors_task.runSynPrivateLocationMonitorsTaskSoon)({
      server
    });
    return result.statuses.map(({
      id,
      success
    }) => ({
      id,
      deleted: success
    }));
  }
});
exports.deleteSyntheticsParamsBulkRoute = deleteSyntheticsParamsBulkRoute;