"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUptimeIndexPattern = void 0;
var _server = require("@kbn/data-views-plugin/server");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUptimeIndexPattern = async ({
  syntheticsEsClient
}) => {
  const indexPatternsFetcher = new _server.IndexPatternsFetcher(syntheticsEsClient.baseESClient);
  try {
    const {
      fields
    } = await indexPatternsFetcher.getFieldsForWildcard({
      pattern: _constants.SYNTHETICS_INDEX_PATTERN
    });
    return {
      fields,
      title: _constants.SYNTHETICS_INDEX_PATTERN
    };
  } catch (e) {
    var _e$output;
    const notExists = ((_e$output = e.output) === null || _e$output === void 0 ? void 0 : _e$output.statusCode) === 404;
    if (notExists) {
      // eslint-disable-next-line no-console
      console.error(`Could not get dynamic index pattern because indices "${_constants.SYNTHETICS_INDEX_PATTERN}" don't exist`);
      return;
    }

    // re-throw
    throw e;
  }
};
exports.getUptimeIndexPattern = getUptimeIndexPattern;