"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setTLSRecoveredAlertsContext = exports.getTLSAlertDocument = exports.getCertSummary = void 0;
var _moment = _interopRequireDefault(require("moment/moment"));
var _common = require("@kbn/observability-plugin/common");
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _action_variables = require("../action_variables");
var _translations = require("../translations");
var _field_names = require("../../../common/field_names");
var _common2 = require("../common");
var _translations2 = require("../../../common/rules/synthetics/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getValidBefore = notBefore => {
  if (!notBefore) return {
    summary: 'Error, missing `not_before` date.'
  };
  const relativeDate = (0, _moment.default)().diff(notBefore, 'days');
  const formattedDate = (0, _moment.default)(notBefore).format('MMM D, YYYY z');
  return relativeDate >= 0 ? {
    summary: _translations.tlsTranslations.validBeforeExpiredString(formattedDate, relativeDate),
    status: _translations.tlsTranslations.agingLabel
  } : {
    summary: _translations.tlsTranslations.validBeforeExpiringString(formattedDate, Math.abs(relativeDate)),
    status: _translations.tlsTranslations.invalidLabel
  };
};
const getValidAfter = notAfter => {
  if (!notAfter) return {
    summary: 'Error, missing `not_after` date.'
  };
  const relativeDate = (0, _moment.default)().diff(notAfter, 'days');
  const formattedDate = (0, _moment.default)(notAfter).format('MMM D, YYYY z');
  return relativeDate >= 0 ? {
    summary: _translations.tlsTranslations.validAfterExpiredString(formattedDate, relativeDate),
    status: _translations.tlsTranslations.expiredLabel
  } : {
    summary: _translations.tlsTranslations.validAfterExpiringString(formattedDate, Math.abs(relativeDate)),
    status: _translations.tlsTranslations.expiringLabel
  };
};
const getCertSummary = (cert, expirationThreshold, ageThreshold) => {
  var _cert$not_after, _cert$not_before, _cert$sha, _cert$common_name, _cert$issuer;
  const isExpiring = new Date((_cert$not_after = cert.not_after) !== null && _cert$not_after !== void 0 ? _cert$not_after : '').valueOf() < expirationThreshold;
  const isAging = new Date((_cert$not_before = cert.not_before) !== null && _cert$not_before !== void 0 ? _cert$not_before : '').valueOf() < ageThreshold;
  let content = null;
  if (isExpiring) {
    content = getValidAfter(cert.not_after);
  } else if (isAging) {
    content = getValidBefore(cert.not_before);
  }
  const {
    summary = '',
    status = ''
  } = content || {};
  return {
    summary,
    status,
    sha256: (_cert$sha = cert.sha256) !== null && _cert$sha !== void 0 ? _cert$sha : '',
    commonName: (_cert$common_name = cert.common_name) !== null && _cert$common_name !== void 0 ? _cert$common_name : '',
    issuer: (_cert$issuer = cert.issuer) !== null && _cert$issuer !== void 0 ? _cert$issuer : '',
    monitorName: cert.monitorName,
    monitorId: cert.configId,
    serviceName: cert.serviceName,
    monitorType: cert.monitorType,
    locationId: cert.locationId,
    locationName: cert.locationName,
    monitorUrl: cert.monitorUrl,
    configId: cert.configId,
    monitorTags: cert.tags,
    lastErrorMessage: cert.errorMessage,
    lastErrorStack: cert.errorStackTrace,
    labels: cert.labels,
    reason: summary,
    hostName: cert.hostName,
    checkedAt: cert['@timestamp']
  };
};
exports.getCertSummary = getCertSummary;
const getTLSAlertDocument = (cert, monitorSummary, uuid) => {
  var _monitorSummary$monit;
  return {
    [_field_names.CERT_COMMON_NAME]: cert.common_name,
    [_field_names.CERT_ISSUER_NAME]: cert.issuer,
    [_field_names.CERT_VALID_NOT_AFTER]: cert.not_after,
    [_field_names.CERT_VALID_NOT_BEFORE]: cert.not_before,
    [_field_names.CERT_HASH_SHA256]: cert.sha256,
    [_ruleDataUtils.ALERT_UUID]: uuid,
    [_ruleDataUtils.ALERT_REASON]: (0, _common2.generateAlertMessage)(_translations2.TlsTranslations.defaultActionMessage, monitorSummary),
    [_field_names.MONITOR_ID]: monitorSummary.monitorId,
    [_field_names.MONITOR_TYPE]: monitorSummary.monitorType,
    [_field_names.MONITOR_NAME]: monitorSummary.monitorName,
    [_field_names.SERVICE_NAME]: monitorSummary.serviceName,
    [_field_names.URL_FULL]: monitorSummary.monitorUrl,
    [_field_names.OBSERVER_GEO_NAME]: monitorSummary.locationName ? [monitorSummary.locationName] : [],
    [_field_names.OBSERVER_NAME]: monitorSummary.locationId ? [monitorSummary.locationId] : [],
    [_field_names.ERROR_MESSAGE]: monitorSummary.lastErrorMessage,
    [_field_names.AGENT_NAME]: monitorSummary.hostName,
    // done to avoid assigning null to the field
    [_field_names.ERROR_STACK_TRACE]: monitorSummary.lastErrorStack ? monitorSummary.lastErrorStack : undefined,
    'location.id': monitorSummary.locationId ? [monitorSummary.locationId] : [],
    'location.name': monitorSummary.locationName ? [monitorSummary.locationName] : [],
    labels: cert.labels,
    configId: monitorSummary.configId,
    'monitor.tags': (_monitorSummary$monit = monitorSummary.monitorTags) !== null && _monitorSummary$monit !== void 0 ? _monitorSummary$monit : []
  };
};
exports.getTLSAlertDocument = getTLSAlertDocument;
const setTLSRecoveredAlertsContext = async ({
  alertsClient,
  basePath,
  spaceId,
  latestPings
}) => {
  var _alertsClient$getReco;
  const recoveredAlerts = (_alertsClient$getReco = alertsClient.getRecoveredAlerts()) !== null && _alertsClient$getReco !== void 0 ? _alertsClient$getReco : [];
  for (const recoveredAlert of recoveredAlerts) {
    var _latestPing$tls$serve, _latestPing$tls, _latestPing$tls$serve2, _latestPing$tls$serve3, _latestPing$tls$serve4, _latestPing$tls2, _latestPing$tls2$serv, _latestPing$tls2$serv2, _latestPing$tls3, _latestPing$tls3$serv, _latestPing$tls3$serv2, _latestPing$tls4, _latestPing$tls4$serv, _latestPing$tls4$serv2;
    const recoveredAlertId = recoveredAlert.alert.getId();
    const alertUuid = recoveredAlert.alert.getUuid();
    const state = recoveredAlert.alert.getState();
    const alertUrl = await (0, _common.getAlertDetailsUrl)(basePath, spaceId, alertUuid);
    const configId = state.configId;
    const latestPing = latestPings.find(ping => ping.config_id === configId);
    const previousStatus = _i18n.i18n.translate('xpack.synthetics.alerts.tls.previousStatus', {
      defaultMessage: 'Certificate {commonName} {summary}',
      values: {
        commonName: state.commonName,
        summary: state.summary
      }
    });
    const newCommonName = (_latestPing$tls$serve = latestPing === null || latestPing === void 0 ? void 0 : (_latestPing$tls = latestPing.tls) === null || _latestPing$tls === void 0 ? void 0 : (_latestPing$tls$serve2 = _latestPing$tls.server) === null || _latestPing$tls$serve2 === void 0 ? void 0 : (_latestPing$tls$serve3 = _latestPing$tls$serve2.x509) === null || _latestPing$tls$serve3 === void 0 ? void 0 : _latestPing$tls$serve3.subject.common_name) !== null && _latestPing$tls$serve !== void 0 ? _latestPing$tls$serve : '';
    const newExpiryDate = (_latestPing$tls$serve4 = latestPing === null || latestPing === void 0 ? void 0 : (_latestPing$tls2 = latestPing.tls) === null || _latestPing$tls2 === void 0 ? void 0 : (_latestPing$tls2$serv = _latestPing$tls2.server) === null || _latestPing$tls2$serv === void 0 ? void 0 : (_latestPing$tls2$serv2 = _latestPing$tls2$serv.x509) === null || _latestPing$tls2$serv2 === void 0 ? void 0 : _latestPing$tls2$serv2.not_after) !== null && _latestPing$tls$serve4 !== void 0 ? _latestPing$tls$serve4 : '';
    const {
      summary
    } = getValidAfter(newExpiryDate);
    let newStatus = _i18n.i18n.translate('xpack.synthetics.alerts.tls.newStatus', {
      defaultMessage: 'Certificate {commonName} {summary}',
      values: {
        commonName: newCommonName,
        summary
      }
    });
    let newSummary = '';
    if (state.sha256 !== (latestPing === null || latestPing === void 0 ? void 0 : (_latestPing$tls3 = latestPing.tls) === null || _latestPing$tls3 === void 0 ? void 0 : (_latestPing$tls3$serv = _latestPing$tls3.server) === null || _latestPing$tls3$serv === void 0 ? void 0 : (_latestPing$tls3$serv2 = _latestPing$tls3$serv.hash) === null || _latestPing$tls3$serv2 === void 0 ? void 0 : _latestPing$tls3$serv2.sha256)) {
      newSummary = _i18n.i18n.translate('xpack.synthetics.alerts.tls.newSummary', {
        defaultMessage: 'Monitor certificate has been updated.'
      });
    }
    if (state.sha256 === (latestPing === null || latestPing === void 0 ? void 0 : (_latestPing$tls4 = latestPing.tls) === null || _latestPing$tls4 === void 0 ? void 0 : (_latestPing$tls4$serv = _latestPing$tls4.server) === null || _latestPing$tls4$serv === void 0 ? void 0 : (_latestPing$tls4$serv2 = _latestPing$tls4$serv.hash) === null || _latestPing$tls4$serv2 === void 0 ? void 0 : _latestPing$tls4$serv2.sha256) || !latestPing) {
      // in this case it seems like threshold has been changed, but the cert is the same
      newSummary = _i18n.i18n.translate('xpack.synthetics.alerts.tls.newSummaryThreshold', {
        defaultMessage: 'Expiry/Age threshold has been updated.'
      });
      newStatus = previousStatus;
    }
    const context = {
      ...state,
      newStatus,
      previousStatus,
      summary: newSummary,
      [_action_variables.ALERT_DETAILS_URL]: alertUrl
    };
    alertsClient.setAlertData({
      id: recoveredAlertId,
      context
    });
  }
};
exports.setTLSRecoveredAlertsContext = setTLSRecoveredAlertsContext;