"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSyntheticsPrivateLocations = exports.fetchAgentPolicies = exports.editSyntheticsPrivateLocation = exports.deleteSyntheticsPrivateLocation = exports.createSyntheticsPrivateLocation = void 0;
var _constants = require("../../../../../common/constants");
var _api_service = require("../../../../utils/api_service/api_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchAgentPolicies = async () => {
  return await _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.AGENT_POLICIES);
};
exports.fetchAgentPolicies = fetchAgentPolicies;
const createSyntheticsPrivateLocation = async newLocation => {
  return await _api_service.apiService.post(_constants.SYNTHETICS_API_URLS.PRIVATE_LOCATIONS, newLocation, undefined, {
    version: _constants.INITIAL_REST_VERSION
  });
};
exports.createSyntheticsPrivateLocation = createSyntheticsPrivateLocation;
const editSyntheticsPrivateLocation = async ({
  locationId,
  newAttributes
}) => {
  return _api_service.apiService.put(`${_constants.SYNTHETICS_API_URLS.PRIVATE_LOCATIONS}/${locationId}`, newAttributes, undefined, {
    version: _constants.INITIAL_REST_VERSION
  });
};
exports.editSyntheticsPrivateLocation = editSyntheticsPrivateLocation;
const getSyntheticsPrivateLocations = async () => {
  return await _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.PRIVATE_LOCATIONS, {
    version: _constants.INITIAL_REST_VERSION
  });
};
exports.getSyntheticsPrivateLocations = getSyntheticsPrivateLocations;
const deleteSyntheticsPrivateLocation = async locationId => {
  return await _api_service.apiService.delete(_constants.SYNTHETICS_API_URLS.PRIVATE_LOCATIONS + `/${locationId}`, {
    version: _constants.INITIAL_REST_VERSION
  });
};
exports.deleteSyntheticsPrivateLocation = deleteSyntheticsPrivateLocation;