"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  DEFAULT_OVERVIEW_VIEW: true,
  monitorOverviewReducer: true
};
exports.monitorOverviewReducer = exports.DEFAULT_OVERVIEW_VIEW = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _models = require("./models");
Object.keys(_models).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _models[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _models[key];
    }
  });
});
var _actions = require("./actions");
Object.keys(_actions).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _actions[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _actions[key];
    }
  });
});
var _selectors = require("./selectors");
Object.keys(_selectors).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _selectors[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _selectors[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_OVERVIEW_VIEW = exports.DEFAULT_OVERVIEW_VIEW = _models.overviewViews[0];
const initialState = {
  pageState: {
    perPage: 16,
    sortOrder: 'asc',
    sortField: 'status'
  },
  trendStats: {},
  groupBy: {
    field: 'none',
    order: 'asc'
  },
  flyoutConfig: null,
  isErrorPopoverOpen: null,
  view: DEFAULT_OVERVIEW_VIEW
};
const monitorOverviewReducer = exports.monitorOverviewReducer = (0, _toolkit.createReducer)(initialState, builder => {
  builder.addCase(_actions.setOverviewPageStateAction, (state, action) => {
    state.pageState = {
      ...state.pageState,
      ...action.payload
    };
  }).addCase(_actions.setOverviewGroupByAction, (state, action) => {
    state.groupBy = {
      ...state.groupBy,
      ...action.payload
    };
  }).addCase(_actions.setFlyoutConfig, (state, action) => {
    state.flyoutConfig = action.payload;
  }).addCase(_actions.toggleErrorPopoverOpen, (state, action) => {
    state.isErrorPopoverOpen = action.payload;
  }).addCase(_actions.trendStatsBatch.get, (state, action) => {
    for (const {
      configId,
      locationId
    } of action.payload) {
      if (!state.trendStats[configId + locationId]) {
        state.trendStats[configId + locationId] = 'loading';
      }
    }
  }).addCase(_actions.trendStatsBatch.fail, (state, action) => {
    for (const {
      configId,
      locationId
    } of action.payload) {
      if (state.trendStats[configId + locationId] === 'loading') {
        state.trendStats[configId + locationId] = null;
      }
    }
  }).addCase(_actions.trendStatsBatch.success, (state, action) => {
    for (const key of Object.keys(action.payload.trendStats)) {
      state.trendStats[key] = action.payload.trendStats[key];
    }
    for (const {
      configId,
      locationId
    } of action.payload.batch) {
      if (!action.payload.trendStats[configId + locationId]) {
        state.trendStats[configId + locationId] = null;
      }
    }
  }).addCase(_actions.setOverviewViewAction, (state, action) => {
    state.view = action.payload;
  });
});