"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enableMonitorAlertEffect = enableMonitorAlertEffect;
exports.fetchMonitorFiltersEffect = fetchMonitorFiltersEffect;
exports.fetchMonitorListEffect = fetchMonitorListEffect;
exports.upsertMonitorEffect = upsertMonitorEffect;
var _effects = require("redux-saga/effects");
var _overview_status = require("../overview_status");
var _alert_rules = require("../alert_rules");
var _runtime_types = require("../../../../../common/runtime_types");
var _kibana_service = require("../../../../utils/kibana_service");
var _overview = require("../overview");
var _selectors = require("../overview/selectors");
var _fetch_effect = require("../utils/fetch_effect");
var _http_error = require("../utils/http_error");
var _actions = require("./actions");
var _api = require("./api");
var _toast_title = require("./toast_title");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function* fetchMonitorListEffect() {
  yield (0, _effects.debounce)(300,
  // Only take the latest while ignoring any intermediate triggers
  [_actions.fetchMonitorListAction.get, _actions.quietFetchMonitorListAction], (0, _fetch_effect.fetchEffectFactory)(_api.fetchMonitorManagementList, _actions.fetchMonitorListAction.success, _actions.fetchMonitorListAction.fail));
}
function* enableMonitorAlertEffect() {
  yield (0, _effects.takeEvery)(_actions.enableMonitorAlertAction.get, function* (action) {
    try {
      var _ConfigKey$ALERT_CONF, _ConfigKey$ALERT_CONF2;
      const response = yield (0, _effects.call)(_api.fetchUpsertMonitor, action.payload);
      yield (0, _effects.put)(_actions.enableMonitorAlertAction.success(response));
      const pageState = yield (0, _effects.select)(_overview.selectOverviewPageState);
      (0, _fetch_effect.sendSuccessToast)(action.payload.success);
      yield (0, _effects.put)(_overview_status.fetchOverviewStatusAction.get({
        pageState
      }));
      if ((_ConfigKey$ALERT_CONF = response[_runtime_types.ConfigKey.ALERT_CONFIG]) !== null && _ConfigKey$ALERT_CONF !== void 0 && (_ConfigKey$ALERT_CONF2 = _ConfigKey$ALERT_CONF.status) !== null && _ConfigKey$ALERT_CONF2 !== void 0 && _ConfigKey$ALERT_CONF2.enabled) {
        yield (0, _effects.put)(_alert_rules.enableDefaultAlertingAction.get());
      }
    } catch (error) {
      (0, _fetch_effect.sendErrorToast)(action.payload.error, error);
      yield (0, _effects.put)(_actions.enableMonitorAlertAction.fail({
        configId: action.payload.configId,
        error: (0, _http_error.serializeHttpFetchError)(error, action.payload)
      }));
    }
  });
}
function* upsertMonitorEffect() {
  yield (0, _effects.takeEvery)(_actions.fetchUpsertMonitorAction, function* (action) {
    try {
      const response = yield (0, _effects.call)(_api.fetchUpsertMonitor, action.payload);
      yield (0, _effects.put)((0, _actions.fetchUpsertSuccessAction)(response));
      _kibana_service.kibanaService.toasts.addSuccess({
        title: (0, _toast_title.toastTitle)({
          title: action.payload.success.message,
          testAttribute: action.payload.success.testAttribute
        }),
        toastLifeTimeMs: action.payload.success.lifetimeMs
      });
    } catch (error) {
      _kibana_service.kibanaService.toasts.addError(error, {
        ...action.payload.error.message,
        toastLifeTimeMs: action.payload.error.lifetimeMs
      });
      yield (0, _effects.put)((0, _actions.fetchUpsertFailureAction)({
        configId: action.payload.configId,
        error: (0, _http_error.serializeHttpFetchError)(error, action.payload)
      }));
    } finally {
      if (action.payload.shouldQuietFetchAfterSuccess !== false) {
        const monitorState = yield (0, _effects.select)(_selectors.selectOverviewState);
        if (hasPageState(monitorState)) {
          yield (0, _effects.put)(_overview_status.quietFetchOverviewStatusAction.get({
            pageState: monitorState.pageState
          }));
        }
      }
      yield (0, _effects.put)((0, _actions.clearMonitorUpsertStatus)(action.payload.configId));
    }
  });
}
function hasPageState(value) {
  return Object.keys(value).includes('pageState');
}
function* fetchMonitorFiltersEffect() {
  yield (0, _effects.takeLatest)(_actions.fetchMonitorFiltersAction.get, (0, _fetch_effect.fetchEffectFactory)(_api.fetchMonitorFilters, _actions.fetchMonitorFiltersAction.success, _actions.fetchMonitorFiltersAction.fail));
}