"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSyntheticsAppProps = void 0;
exports.renderApp = renderApp;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18n = require("@kbn/i18n");
var _kibana_service = require("../../utils/kibana_service");
var _adapters = require("./utils/adapters");
var _constants = require("../../../common/constants");
var _synthetics_app = require("./synthetics_app");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/render_app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getSyntheticsAppProps = () => {
  var _capabilities$uptime$;
  const {
    isDev,
    isServerless,
    coreStart,
    startPlugins,
    setupPlugins,
    appMountParameters
  } = _kibana_service.kibanaService;
  const {
    application: {
      capabilities
    },
    chrome: {
      setBadge,
      setHelpExtension
    },
    docLinks,
    http: {
      basePath
    },
    i18n,
    theme
  } = _kibana_service.kibanaService.coreStart;
  const {
    apm,
    infrastructure,
    logs
  } = (0, _adapters.getIntegratedAppAvailability)(capabilities, _constants.INTEGRATED_SOLUTIONS);
  const canSave = (_capabilities$uptime$ = capabilities.uptime.save) !== null && _capabilities$uptime$ !== void 0 ? _capabilities$uptime$ : false; // TODO: Determine for synthetics
  const darkMode = theme.getTheme().darkMode;
  return {
    isDev,
    setupPlugins,
    canSave,
    coreStart,
    i18n,
    startPlugins,
    basePath: basePath.get(),
    darkMode,
    commonlyUsedRanges: coreStart.uiSettings.get(_constants.DEFAULT_TIMEPICKER_QUICK_RANGES),
    isApmAvailable: apm,
    isInfraAvailable: infrastructure,
    isLogsAvailable: logs,
    renderGlobalHelpControls: () => setHelpExtension({
      appName: SYNTHETICS_APP_NAME,
      links: [{
        linkType: 'documentation',
        href: `${docLinks.links.observability.monitorUptimeSynthetics}`
      }, {
        linkType: 'discuss',
        href: 'https://discuss.elastic.co/c/uptime' // Redirects to https://discuss.elastic.co/c/observability/synthetics/75
      }]
    }),
    setBadge,
    appMountParameters,
    isServerless
  };
};
exports.getSyntheticsAppProps = getSyntheticsAppProps;
function renderApp(appMountParameters) {
  const props = getSyntheticsAppProps();
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_synthetics_app.SyntheticsApp, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 19
    }
  })), appMountParameters.element);
  return () => {
    props.startPlugins.data.search.session.clear();
    _reactDom.default.unmountComponentAtNode(appMountParameters.element);
  };
}
const SYNTHETICS_APP_NAME = _i18n.i18n.translate('xpack.synthetics.header.appName', {
  defaultMessage: 'Synthetics'
});