"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = MonitorStatusAlert;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _reactQuery = require("@tanstack/react-query");
var _public = require("@kbn/observability-shared-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _status_rule_ui = require("../../../components/alerts/status_rule_ui");
var _kibana_service = require("../../../../../utils/kibana_service");
var _state = require("../../../state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/lib/alert_types/lazy_wrapper/monitor_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// eslint-disable-next-line import/no-default-export
function MonitorStatusAlert({
  coreStart,
  plugins,
  params
}) {
  _kibana_service.kibanaService.coreStart = coreStart;
  const queryClient = new _reactQuery.QueryClient();
  const {
    ruleParams
  } = params;
  return /*#__PURE__*/_react.default.createElement(_public.InspectorContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: _state.store,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
    services: {
      ...coreStart,
      ...plugins
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 11
    }
  }, params.id && (0, _lodash.isEmpty)(ruleParams) && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.alertRule.monitorStatus.description",
    defaultMessage: "Manage synthetics monitor status rule actions.",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 17
    }
  })), (!params.id || !(0, _lodash.isEmpty)(ruleParams)) && /*#__PURE__*/_react.default.createElement(_status_rule_ui.StatusRuleComponent, {
    ruleParams: ruleParams,
    setRuleParams: params.setRuleParams,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  })))));
}
module.exports = exports.default;