"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyntheticsSharedContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/kibana-react-plugin/common");
var _reactRedux = require("react-redux");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _reactQuery = require("@tanstack/react-query");
var _synthetics_refresh_context = require("./synthetics_refresh_context");
var _synthetics_data_view_context = require("./synthetics_data_view_context");
var _state = require("../state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/contexts/synthetics_shared_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getEmptyFunctionComponent = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
const SyntheticsSharedContext = ({
  reduxStore,
  coreStart,
  setupPlugins,
  startPlugins,
  children,
  darkMode,
  reload$
}) => {
  const queryClient = new _reactQuery.QueryClient();
  const spacesApi = startPlugins.spaces;
  const ContextWrapper = (0, _react.useMemo)(() => spacesApi ? spacesApi.ui.components.getSpacesContextProvider : getEmptyFunctionComponent, [spacesApi]);
  return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...coreStart,
      ...setupPlugins,
      storage: _state.storage,
      contentManagement: startPlugins.contentManagement,
      data: startPlugins.data,
      inspector: startPlugins.inspector,
      triggersActionsUi: startPlugins.triggersActionsUi,
      observability: startPlugins.observability,
      observabilityShared: startPlugins.observabilityShared,
      observabilityAIAssistant: startPlugins.observabilityAIAssistant,
      exploratoryView: startPlugins.exploratoryView,
      cases: startPlugins.cases,
      spaces: startPlugins.spaces,
      fleet: startPlugins.fleet,
      share: startPlugins.share,
      unifiedSearch: startPlugins.unifiedSearch,
      embeddable: startPlugins.embeddable,
      slo: startPlugins.slo,
      serverless: startPlugins.serverless,
      charts: startPlugins.charts
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: darkMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: reduxStore !== null && reduxStore !== void 0 ? reduxStore : _state.store,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_synthetics_refresh_context.SyntheticsRefreshContextProvider, {
    reload$: reload$,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_synthetics_data_view_context.SyntheticsDataViewContextProvider, {
    dataViews: startPlugins.dataViews,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application: coreStart.application
    },
    style: {
      height: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(ContextWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 19
    }
  }, children))))))));
};
exports.SyntheticsSharedContext = SyntheticsSharedContext;