"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimpleTestResults = SimpleTestResults;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _browser_test_results = require("./browser_test_results");
var _kibana_service = require("../../../../../utils/kibana_service");
var _use_simple_run_once_monitors = require("../hooks/use_simple_run_once_monitors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/test_now_mode/manual_test_run_mode/simple_test_results.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SimpleTestResults({
  name,
  testRunId,
  expectPings,
  onDone
}) {
  const {
    summaryDocs,
    retriesExceeded
  } = (0, _use_simple_run_once_monitors.useSimpleRunOnceMonitors)({
    testRunId,
    expectSummaryDocs: expectPings
  });
  (0, _react.useEffect)(() => {
    if (retriesExceeded) {
      const {
        coreStart,
        toasts
      } = _kibana_service.kibanaService;
      toasts.addDanger({
        text: _browser_test_results.FAILED_TO_SCHEDULE,
        title: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.synthetics.manualTestRun.failedTest.name",
          defaultMessage: "Manual test run failed for {name}",
          values: {
            name
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 34,
            columnNumber: 13
          }
        }), coreStart)
      }, {
        toastLifeTimeMs: 10000
      });
      onDone(testRunId);
    }
  }, [name, onDone, retriesExceeded, testRunId]);
  (0, _react.useEffect)(() => {
    if (summaryDocs) {
      if (summaryDocs.length >= expectPings) {
        onDone(testRunId);
      }
    }
  }, [testRunId, expectPings, summaryDocs, onDone]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
}